/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.gui;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.layered.LayeredGui;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.InputSignGui;
import io.github.sakurawald.core.gui.layer.SingleLineLayer;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PagedGui<T>
extends LayeredGui {
    @Nullable
    private final SimpleGui parent;
    private final List<T> entities;
    private final int pageIndex;
    private final class_2561 prefixTitle;
    private final SingleLineLayer footer = new SingleLineLayer();

    public PagedGui(@Nullable SimpleGui parent, class_3222 player, class_2561 prefixTitle, @NotNull List<T> entities, int pageIndex) {
        super(class_3917.field_17327, player, false);
        this.parent = parent;
        this.prefixTitle = prefixTitle;
        this.pageIndex = pageIndex;
        this.entities = entities;
    }

    public boolean open() {
        this.drawPagedGui();
        return super.open();
    }

    protected abstract PagedGui<T> make(@Nullable SimpleGui var1, class_3222 var2, class_2561 var3, @NotNull List<T> var4, int var5);

    private void drawNavigator(int pageIndex) {
        SingleLineLayer pageLayer = new SingleLineLayer(GuiHelper.makeSlotPlaceholder());
        pageLayer.setSlot(0, GuiHelper.makePreviousPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex - 1)));
        pageLayer.setSlot(this.getWidth() - 1, GuiHelper.makeNextPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex + 1)));
        pageLayer.setSlot(this.getWidth() - 2, GuiHelper.makeSearchButton(this.getPlayer()).setCallback(() -> new InputSignGui(this.getPlayer(), null){

            public void onClose() {
                String keyword = this.reduceInputOrEmpty();
                PagedGui.this.search(keyword).open();
            }
        }.open()));
        this.addLayer(pageLayer, 0, this.getHeight() - 1);
    }

    protected void drawPagedGui() {
        this.drawTitle();
        this.drawPagedGui(this.entities);
        this.drawNavigator(this.pageIndex);
        this.addLayer(this.footer, 0, this.getHeight() - 1);
    }

    private void drawPagedGui(@NotNull List<T> entities) {
        int slotIndex = 0;
        for (int i = this.getEntityBeginIndex(this.pageIndex); i < this.getEntityEndIndex(this.pageIndex); ++i) {
            T entity = entities.get(i);
            this.setSlot(slotIndex++, this.toGuiElement(entity));
        }
    }

    private void tryChangePage(int newPageIndex) {
        int entityBeginIndex = this.getEntityBeginIndex(newPageIndex);
        if (entityBeginIndex < 0 || entityBeginIndex >= this.getEntitySize()) {
            return;
        }
        this.make(this.parent, this.getPlayer(), this.prefixTitle, this.entities, newPageIndex).open();
    }

    @NotNull
    protected PagedGui<T> search(String keywords) {
        return this.make(this.parent, this.getPlayer(), TextHelper.getTextByKey(this.getPlayer(), "gui.search.title", keywords), this.filter(keywords), 0);
    }

    protected void addEntity(T entity) {
        this.entities.add(entity);
        this.reopen();
    }

    protected void deleteEntity(T entity) {
        this.entities.remove(entity);
        this.reopen();
    }

    protected void reopen() {
        this.make(this.parent, this.getPlayer(), this.prefixTitle, this.entities, 0).open();
    }

    protected abstract GuiElementInterface toGuiElement(T var1);

    protected abstract List<T> filter(String var1);

    private void drawTitle() {
        class_5250 formatted = this.prefixTitle.method_27661().method_10852(TextHelper.getTextByKey(this.getPlayer(), "gui.page.title", this.getCurrentPageNumber(), this.getMaxPageNumber()));
        this.setTitle((class_2561)formatted);
    }

    private int getEntitySize() {
        return this.entities.size();
    }

    private int getCurrentPageNumber() {
        return this.pageIndex + 1;
    }

    private int getMaxPageNumber() {
        if (this.getEntitySize() == 0) {
            return 1;
        }
        int a = this.getEntitySize();
        int b = this.getEntityPageSize();
        int bias = 0;
        if (a % b != 0) {
            bias = 1;
        }
        return a / b + bias;
    }

    private int getEntityPageSize() {
        return this.getWidth() * this.getHeight() - 9;
    }

    private int getEntityBeginIndex(int pageIndex) {
        return this.getEntityPageSize() * pageIndex;
    }

    private int getEntityEndIndex(int pageIndex) {
        return Math.min(this.getEntityBeginIndex(pageIndex + 1), this.getEntitySize());
    }

    public void onClose() {
        if (this.parent != null) {
            this.parent.open();
        }
    }

    @Nullable
    protected SimpleGui getGui() {
        return this.gui;
    }

    @Nullable
    public SimpleGui getParent() {
        return this.parent;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    public SingleLineLayer getFooter() {
        return this.footer;
    }
}

