/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.scheduler;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.manager.abst.BaseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class ScheduleManager
extends BaseManager {
    public static final String CRON_EVERY_SECOND = "* * * ? * *";
    public static final String CRON_EVERY_MINUTE = "0 * * ? * * *";
    private Scheduler scheduler;

    public ScheduleManager() {
        Level level = Level.getLevel((String)Configs.configHandler.model().core.scheduler.logger_level);
        Configurator.setAllLevels((String)"org.quartz", (Level)level);
        this.resetScheduler();
    }

    @Override
    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> Managers.getScheduleManager().startScheduler());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> Managers.getScheduleManager().shutdownScheduler());
    }

    public void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void rescheduleJob(TriggerKey triggerKey, Trigger newTrigger) throws SchedulerException {
        this.scheduler.rescheduleJob(triggerKey, newTrigger);
    }

    public void deleteJobs(Class<?> clazz) {
        ArrayList<JobKey> jobKeys = new ArrayList<JobKey>(this.getJobKeys(clazz.getName()));
        this.deleteJobs(jobKeys);
    }

    private void deleteJobs(List<JobKey> jobKeys) {
        try {
            LogUtil.debug("Delete job keys: {}", jobKeys);
            this.scheduler.deleteJobs(jobKeys);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to delete jobs: " + String.valueOf((Object)e), new Object[0]);
        }
    }

    private Set<JobKey> getJobKeys(@NotNull String jobGroup) {
        GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroup);
        try {
            return this.scheduler.getJobKeys(groupMatcher);
        }
        catch (SchedulerException e) {
            LogUtil.error("Exception in ScheduleUtil.getJobKeys", new Object[]{e});
            return Collections.emptySet();
        }
    }

    public void triggerJobs(@NotNull String jobGroup) {
        this.getJobKeys(jobGroup).forEach(jobKey -> {
            try {
                this.scheduler.triggerJob(jobKey);
            }
            catch (SchedulerException e) {
                LogUtil.error("Exception in ScheduleUtil.triggerJobs", new Object[]{e});
            }
        });
    }

    private void resetScheduler() {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            this.scheduler = stdSchedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void startScheduler() {
        this.resetScheduler();
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            LogUtil.error("Exception in ScheduleUtil.startScheduler", new Object[]{e});
        }
    }

    private void shutdownScheduler() {
        try {
            this.scheduler.shutdown(false);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                this.resetScheduler();
            }
        }
        catch (SchedulerException e) {
            LogUtil.error("Exception in ScheduleUtil.shutdownScheduler", new Object[]{e});
        }
    }
}

