/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.back.structure;

import io.github.sakurawald.core.auxiliary.CollectionUtil;
import io.github.sakurawald.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.module.initializer.back.structure.LocationEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class LocationHistory {
    private List<LocationEntry> history = new ArrayList<LocationEntry>();

    public void pushEntry(LocationEntry entry) {
        this.history.add(entry);
        this.sortEntries();
    }

    public Iterator<LocationEntry> listEntries() {
        return this.history.iterator();
    }

    @Nullable
    public LocationEntry getLatestEntry() {
        return this.history.isEmpty() ? null : this.history.get(this.history.size() - 1);
    }

    @Nullable
    public LocationEntry findEntry(int lastNLocation, @Nullable Dimension targetDimension) {
        List targetList = this.history.stream().filter(it -> targetDimension == null || it.getLocation().sameLevel((class_1937)targetDimension.getValue())).collect(Collectors.toCollection(ArrayList::new));
        int index = targetList.size() - lastNLocation;
        if (!CollectionUtil.validIndex(index, targetList)) {
            return null;
        }
        return (LocationEntry)targetList.get(index);
    }

    public void clearEntries() {
        this.history.clear();
    }

    public void sortEntries() {
        Collections.sort(this.history);
    }

    public void trimEntries(int length) {
        if (this.history.size() < length) {
            return;
        }
        int start = this.history.size() - length;
        int end = this.history.size();
        this.history = this.history.subList(start, end);
    }
}

