/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.display.helper;

import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.service.display.gui.BaseDisplayGuiFactory;
import io.github.sakurawald.core.service.display.gui.InventoryDisplayGuiFactory;
import io.github.sakurawald.core.service.display.gui.ShulkerBoxDisplayGuiFactory;
import io.github.sakurawald.module.initializer.chat.display.ChatDisplayInitializer;
import io.github.sakurawald.module.initializer.chat.display.gui.EnderChestDisplayGuiFactory;
import io.github.sakurawald.module.initializer.chat.display.gui.ItemDisplayGuiFactory;
import io.github.sakurawald.module.initializer.chat.display.structure.SoftReferenceMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DisplayHelper {
    private static final SoftReferenceMap<String, BaseDisplayGuiFactory> uuid2gui = new SoftReferenceMap();

    private static String bindUUID(BaseDisplayGuiFactory displayGuiFactory) {
        String uuid = UUID.randomUUID().toString();
        uuid2gui.put(uuid, displayGuiFactory);
        return uuid;
    }

    private static void viewDisplayGui(@NotNull class_3222 viewerPlayer, String displayUUID) {
        BaseDisplayGuiFactory baseDisplayGui = uuid2gui.get(displayUUID);
        if (baseDisplayGui == null) {
            TextHelper.sendMessageByKey(viewerPlayer, "display.invalid", new Object[0]);
            return;
        }
        baseDisplayGui.build(viewerPlayer).open();
    }

    public static class_5250 createEnderDisplayText(class_3222 sharingPlayer) {
        String displayUUID = DisplayHelper.bindUUID(new EnderChestDisplayGuiFactory(sharingPlayer));
        return TextHelper.getTextByKey(sharingPlayer, "display.ender_chest.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    public static class_5250 createInvDisplayText(class_3222 sharingPlayer) {
        String displayUUID = DisplayHelper.bindUUID(new InventoryDisplayGuiFactory(sharingPlayer));
        return TextHelper.getTextByKey(sharingPlayer, "display.inventory.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    @NotNull
    public static class_5250 createItemDisplayText(class_3222 sharingPlayer) {
        class_1799 itemStack = sharingPlayer.method_6047().method_7972();
        BaseDisplayGuiFactory displayGui = BaseDisplayGuiFactory.isShulkerBox(itemStack) ? new ShulkerBoxDisplayGuiFactory(sharingPlayer, itemStack, null) : new ItemDisplayGuiFactory(sharingPlayer, itemStack);
        String displayUUID = DisplayHelper.bindUUID(displayGui);
        class_5250 translatable = class_2561.method_43471((String)sharingPlayer.method_6047().method_7909().method_7876());
        translatable.method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
        class_5250 text = TextHelper.getTextByKey(sharingPlayer, "display.item.text", new Object[0]).method_27661();
        text = TextHelper.replaceTextWithMarker((class_2561)text, "item", () -> translatable);
        return text;
    }

    @NotNull
    private static class_2558 makeDisplayClickEvent(String displayUUID) {
        return Managers.getCallbackManager().makeCallbackEvent(player -> DisplayHelper.viewDisplayGui(player, displayUUID), ChatDisplayInitializer.config.model().expiration_duration_s, TimeUnit.SECONDS);
    }
}

