/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.mention;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.job.impl.MentionPlayersJob;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.mention.config.model.ChatMentionConfigModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ChatMentionInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatMentionConfigModel> config = new ObjectConfigurationHandler<ChatMentionConfigModel>("config.json", ChatMentionConfigModel.class);

    private static List<class_3222> resolveMentionedOnlinePlayers(String chatString) {
        String[] onlinePlayerNames = ServerHelper.getServer().method_3858();
        List<class_3222> mentionedPlayers = Arrays.stream(onlinePlayerNames).filter(chatString::contains).sorted(Comparator.comparingInt(String::length).reversed()).map(ServerHelper::getPlayerByName).toList();
        if (!mentionedPlayers.isEmpty()) {
            LogUtil.debug("Submit new mention job: mentionedPlayers = {}", mentionedPlayers.stream().map(PlayerHelper::getName));
            MentionPlayersJob.submitJob(ChatMentionInitializer.config.model().mention_player, mentionedPlayers);
        }
        return mentionedPlayers;
    }

    public static class_2561 replaceMentionText(@NotNull class_2561 original) {
        String chatString = TextHelper.visitString(original);
        List<class_3222> mentionedPlayers = ChatMentionInitializer.resolveMentionedOnlinePlayers(chatString);
        for (class_3222 mentionedPlayer : mentionedPlayers) {
            String playerName = mentionedPlayer.method_7334().getName();
            String replacementString = ChatMentionInitializer.config.model().mention_format.formatted(playerName);
            class_2561 replacementText = TextHelper.getTextByValue(mentionedPlayer, replacementString, new Object[0]);
            original = TextHelper.replaceTextWithRegex(original, playerName, () -> replacementText);
        }
        return original;
    }
}

