/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.deathlog.structure;

import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.minecraft.InventoryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.module.initializer.deathlog.DeathLogInitializer;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class DeathNode {
    public static final String DEATHS_KEY = "Deaths";
    private static final String REMARK_KEY = "remark";
    private static final String TIME_KEY = "time";
    private static final String REASON_KEY = "reason";
    private static final String DIMENSION_KEY = "dimension";
    private static final String X_KEY = "x";
    private static final String Y_KEY = "y";
    private static final String Z_KEY = "z";
    private static final String ARMOR_KEY = "armor";
    private static final String OFFHAND_KEY = "offhand";
    private static final String ITEM_KEY = "item";
    private static final String SCORE_KEY = "score";
    private static final String XP_LEVEL_KEY = "xp_level";
    private static final String XP_PROGRESS_KEY = "xp_progress";
    private static final String INVENTORY_KEY = "inventory";
    public String time;
    public String dimension;
    public double x;
    public double y;
    public double z;
    public String reason;
    public List<class_1799> main;
    public List<class_1799> armor;
    public List<class_1799> offhand;
    public int score;
    public int expLevel;
    public float expProgress;

    public static DeathNode fromNbt(class_2487 nbt) {
        DeathNode deathNode = new DeathNode();
        class_2487 remarkTag = NbtHelper.getCompound(nbt, REMARK_KEY);
        deathNode.time = NbtHelper.getString(remarkTag, TIME_KEY);
        deathNode.dimension = NbtHelper.getString(remarkTag, DIMENSION_KEY);
        deathNode.x = NbtHelper.getDouble(remarkTag, X_KEY);
        deathNode.y = NbtHelper.getDouble(remarkTag, Y_KEY);
        deathNode.z = NbtHelper.getDouble(remarkTag, Z_KEY);
        deathNode.reason = NbtHelper.getString(remarkTag, REASON_KEY);
        class_2487 inventoryNode = NbtHelper.getCompound(nbt, INVENTORY_KEY);
        deathNode.main = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(ITEM_KEY));
        deathNode.armor = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(ARMOR_KEY));
        deathNode.offhand = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(OFFHAND_KEY));
        deathNode.score = NbtHelper.getInt(inventoryNode, SCORE_KEY);
        deathNode.expLevel = NbtHelper.getInt(inventoryNode, XP_LEVEL_KEY);
        deathNode.expProgress = NbtHelper.getFloat(inventoryNode, XP_PROGRESS_KEY);
        return deathNode;
    }

    public static void createDeathNode(@NotNull class_3222 player) {
        if (player.method_31548().method_5442()) {
            return;
        }
        NbtHelper.withNbtFile(DeathLogInitializer.getDeathDataPath(PlayerHelper.getName((class_1657)player)), root -> {
            class_2499 deathNodeList = NbtHelper.withNbtElement(root, DEATHS_KEY, new class_2499());
            deathNodeList.add((Object)DeathNode.makeDeathNodeNbt(player));
        });
    }

    private static void writeRemarkNode(@NotNull class_2487 parent, @NotNull class_3222 player) {
        String time = ChronosUtil.getCurrentDate();
        String reason = player.method_6066().method_5548().getString();
        String dimension = player.method_37908().method_27983().method_29177().toString();
        class_243 position = player.method_19538();
        class_2487 remarkTag = new class_2487();
        remarkTag.method_10582(TIME_KEY, time);
        remarkTag.method_10582(REASON_KEY, reason);
        remarkTag.method_10582(DIMENSION_KEY, dimension);
        remarkTag.method_10549(X_KEY, position.field_1352);
        remarkTag.method_10549(Y_KEY, position.field_1351);
        remarkTag.method_10549(Z_KEY, position.field_1350);
        parent.method_10566(REMARK_KEY, (class_2520)remarkTag);
    }

    private static void writeInventoryNode(@NotNull class_2487 parent, @NotNull class_3222 player) {
        class_2487 inventoryTag = new class_2487();
        class_1661 inventory = player.method_31548();
        inventoryTag.method_10566(ARMOR_KEY, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getArmorStacks((class_1657)player)));
        inventoryTag.method_10566(OFFHAND_KEY, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getOffhandStack((class_1657)player)));
        inventoryTag.method_10566(ITEM_KEY, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getMainStacks((class_1657)player)));
        inventoryTag.method_10569(SCORE_KEY, player.method_7272());
        inventoryTag.method_10569(XP_LEVEL_KEY, player.field_7520);
        inventoryTag.method_10548(XP_PROGRESS_KEY, player.field_7510);
        parent.method_10566(INVENTORY_KEY, (class_2520)inventoryTag);
    }

    @NotNull
    private static class_2487 makeDeathNodeNbt(@NotNull class_3222 player) {
        class_2487 node = new class_2487();
        DeathNode.writeInventoryNode(node, player);
        DeathNode.writeRemarkNode(node, player);
        return node;
    }

    public String getTime() {
        return this.time;
    }

    public String getDimension() {
        return this.dimension;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getReason() {
        return this.reason;
    }

    public List<class_1799> getMain() {
        return this.main;
    }

    public List<class_1799> getArmor() {
        return this.armor;
    }

    public List<class_1799> getOffhand() {
        return this.offhand;
    }

    public int getScore() {
        return this.score;
    }

    public int getExpLevel() {
        return this.expLevel;
    }

    public float getExpProgress() {
        return this.expProgress;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setMain(List<class_1799> main) {
        this.main = main;
    }

    public void setArmor(List<class_1799> armor) {
        this.armor = armor;
    }

    public void setOffhand(List<class_1799> offhand) {
        this.offhand = offhand;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setExpLevel(int expLevel) {
        this.expLevel = expLevel;
    }

    public void setExpProgress(float expProgress) {
        this.expProgress = expProgress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeathNode)) {
            return false;
        }
        DeathNode other = (DeathNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        if (this.getExpLevel() != other.getExpLevel()) {
            return false;
        }
        if (Float.compare(this.getExpProgress(), other.getExpProgress()) != 0) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        List<class_1799> this$main = this.getMain();
        List<class_1799> other$main = other.getMain();
        if (this$main == null ? other$main != null : !((Object)this$main).equals(other$main)) {
            return false;
        }
        List<class_1799> this$armor = this.getArmor();
        List<class_1799> other$armor = other.getArmor();
        if (this$armor == null ? other$armor != null : !((Object)this$armor).equals(other$armor)) {
            return false;
        }
        List<class_1799> this$offhand = this.getOffhand();
        List<class_1799> other$offhand = other.getOffhand();
        return !(this$offhand == null ? other$offhand != null : !((Object)this$offhand).equals(other$offhand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeathNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + this.getScore();
        result = result * 59 + this.getExpLevel();
        result = result * 59 + Float.floatToIntBits(this.getExpProgress());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        List<class_1799> $main = this.getMain();
        result = result * 59 + ($main == null ? 43 : ((Object)$main).hashCode());
        List<class_1799> $armor = this.getArmor();
        result = result * 59 + ($armor == null ? 43 : ((Object)$armor).hashCode());
        List<class_1799> $offhand = this.getOffhand();
        result = result * 59 + ($offhand == null ? 43 : ((Object)$offhand).hashCode());
        return result;
    }

    public String toString() {
        return "DeathNode(time=" + this.getTime() + ", dimension=" + this.getDimension() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", reason=" + this.getReason() + ", main=" + String.valueOf(this.getMain()) + ", armor=" + String.valueOf(this.getArmor()) + ", offhand=" + String.valueOf(this.getOffhand()) + ", score=" + this.getScore() + ", expLevel=" + this.getExpLevel() + ", expProgress=" + this.getExpProgress() + ")";
    }
}

