/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.placeholder;

import com.google.common.collect.ImmutableList;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.RandomUtil;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.placeholder.gui.PlaceholderGui;
import io.github.sakurawald.module.initializer.placeholder.job.UpdateSumUpPlaceholderJob;
import io.github.sakurawald.module.initializer.placeholder.structure.SumUpPlaceholder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.commons.lang3.StringUtils;

@CommandNode(value="placeholder")
@CommandRequirement(level=4)
public class PlaceholderInitializer
extends ModuleInitializer {
    private static final Map<String, Map<String, String>> ROTATE_CACHE = new HashMap<String, Map<String, String>>();
    private static final Pattern ESCAPE_PARSER = Pattern.compile("\\s*([\\s\\S]+)\\s+(\\d+)\\s*");

    @CommandNode(value="list")
    @Document(value="List all placeholders registered in server.")
    private static int list(@CommandSource class_3222 player) {
        ImmutableList list = Placeholders.getPlaceholders().keySet().asList();
        new PlaceholderGui(player, (List<class_2960>)list, 0).open();
        return 1;
    }

    @CommandNode(value="parse")
    @Document(value="Parse a placeholder with a contextual player.")
    private static int list(@CommandSource class_2168 source, Optional<class_3222> player, GreedyString input) {
        class_3222 target = player.orElse(null);
        class_2561 text = TextHelper.getTextByValue(target, (String)input.getValue(), new Object[0]);
        source.method_45068(text);
        return 1;
    }

    private static void registerServerPlaytimePlaceholder() {
        PlaceholderHelper.withServer("server_playtime", server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().playtime)));
    }

    private static void registerPlayerPlaytimePlaceholder() {
        PlaceholderHelper.withPlayer("player_playtime", player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).playtime)));
    }

    private static void registerServerMovedPlaceholder() {
        PlaceholderHelper.withServer("server_moved", server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().moved)));
    }

    private static void registerPlayerMovedPlaceholder() {
        PlaceholderHelper.withPlayer("player_moved", player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).moved)));
    }

    private static void registerServerKilledPlaceholder() {
        PlaceholderHelper.withServer("server_killed", server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().killed)));
    }

    private static void registerPlayerKilledPlaceholder() {
        PlaceholderHelper.withPlayer("player_killed", player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).killed)));
    }

    private static void registerServerPlacedPlaceholder() {
        PlaceholderHelper.withServer("server_placed", server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().placed)));
    }

    private static void registerPlayerPlacedPlaceholder() {
        PlaceholderHelper.withPlayer("player_placed", player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).placed)));
    }

    private static void registerServerMinedPlaceholder() {
        PlaceholderHelper.withServer("server_mined", server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().mined)));
    }

    private static void registerPlayerMinedPlaceholder() {
        PlaceholderHelper.withPlayer("player_mined", player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).mined)));
    }

    public static void registerPrefixPlaceholder() {
        PlaceholderHelper.withPlayer("player_prefix", (player, arg) -> {
            String prefix = PermissionHelper.getPrefix(player.method_5667());
            return TextHelper.getTextByValue(player, prefix, new Object[0]);
        });
    }

    public static void registerSuffixPlaceholder() {
        PlaceholderHelper.withPlayer("player_suffix", (player, arg) -> {
            String prefix = PermissionHelper.getSuffix(player.method_5667());
            return TextHelper.getTextByValue(player, prefix, new Object[0]);
        });
    }

    public static void registerPosPlaceholder() {
        PlaceholderHelper.withPlayer("pos", player -> {
            int x = player.method_31477();
            int y = player.method_31478();
            int z = player.method_31479();
            String dim_name = player.method_37908().method_27983().method_29177().toString();
            String dim_display_name = TextHelper.getValueByKey(player, dim_name);
            Object hoverString = TextHelper.getValueByKey(player, "chat.current_pos");
            switch (dim_name) {
                case "minecraft:overworld": {
                    hoverString = (String)hoverString + "\n" + TextHelper.getValueByKey(player, "minecraft:the_nether") + ": %d %s %d".formatted(x / 8, y, z / 8);
                    break;
                }
                case "minecraft:the_nether": {
                    hoverString = (String)hoverString + "\n" + TextHelper.getValueByKey(player, "minecraft:overworld") + ": %d %s %d".formatted(x * 8, y, z * 8);
                }
            }
            String clickCommand = TextHelper.getValueByKey(player, "chat.xaero_waypoint_add.command");
            return TextHelper.getTextByKey(player, "placeholder.pos", x, y, z, dim_display_name).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction((class_2561)class_2561.method_43470((String)((String)hoverString + "\n")).method_10852(TextHelper.getTextByKey(player, "chat.xaero_waypoint_add", new Object[0])))).method_10958(TextHelper.ClickEvent.makeRunCommandAction(clickCommand)));
        });
    }

    @Override
    protected void onInitialize() {
        PlaceholderInitializer.registerPlayerMinedPlaceholder();
        PlaceholderInitializer.registerServerMinedPlaceholder();
        PlaceholderInitializer.registerPlayerPlacedPlaceholder();
        PlaceholderInitializer.registerServerPlacedPlaceholder();
        PlaceholderInitializer.registerPlayerKilledPlaceholder();
        PlaceholderInitializer.registerServerKilledPlaceholder();
        PlaceholderInitializer.registerPlayerMovedPlaceholder();
        PlaceholderInitializer.registerServerMovedPlaceholder();
        PlaceholderInitializer.registerPlayerPlaytimePlaceholder();
        PlaceholderInitializer.registerServerPlaytimePlaceholder();
        this.registerHealthBarPlaceholder();
        this.registerRotatePlaceholder();
        this.registerHasPermissionPlaceholder();
        this.registerGetMetaPlaceholder();
        this.registerRandomPlayerPlaceholder();
        this.registerRandomPlaceholder();
        this.registerEscapePlaceholder();
        this.registerProtectPlaceholder();
        this.registerDatePlaceholder();
        PlaceholderInitializer.registerPrefixPlaceholder();
        PlaceholderInitializer.registerSuffixPlaceholder();
        PlaceholderInitializer.registerPosPlaceholder();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SumUpPlaceholder.ofServer();
            new UpdateSumUpPlaceholderJob().schedule();
        });
    }

    private void registerDatePlaceholder() {
        PlaceholderHelper.withServer("date", (server, arg) -> {
            if (arg == null || arg.isEmpty()) {
                return class_2561.method_43470((String)ChronosUtil.getCurrentDate());
            }
            try {
                String currentDate = ChronosUtil.getCurrentDate(new SimpleDateFormat((String)arg));
                return class_2561.method_43470((String)currentDate);
            }
            catch (Exception e) {
                return class_2561.method_30163((String)("Invalid date formatter: " + arg));
            }
        });
    }

    private void registerEscapePlaceholder() {
        PlaceholderHelper.withServer("escape", (server, args) -> {
            if (args == null) {
                return PlaceholderHelper.INVALID_TEXT;
            }
            Matcher matcher = ESCAPE_PARSER.matcher((CharSequence)args);
            if (matcher.find()) {
                String placeholder = matcher.group(1);
                int level = Integer.parseInt(matcher.group(2));
                if (level == 1) {
                    return class_2561.method_43470((String)("%" + placeholder + "%"));
                }
                if (level > 1) {
                    return class_2561.method_43470((String)("%fuji:escape " + placeholder + " " + (level - 1) + "%"));
                }
            }
            return class_2561.method_43470((String)("%" + args + "%"));
        });
    }

    private void registerProtectPlaceholder() {
        PlaceholderHelper.withServer("protect", (server, args) -> {
            if (args == null) {
                return class_2561.method_43473();
            }
            return class_2561.method_43470((String)args);
        });
    }

    private void registerHasPermissionPlaceholder() {
        PlaceholderHelper.withPlayer("has_permission", (player, args) -> {
            boolean value = PermissionHelper.hasPermission(player.method_5667(), args);
            return class_2561.method_43470((String)String.valueOf(value));
        });
    }

    private void registerGetMetaPlaceholder() {
        PlaceholderHelper.withPlayer("get_meta", (player, args) -> {
            Optional<String> metaValue = PermissionHelper.getMeta(player.method_5667(), args, String::valueOf);
            return class_2561.method_43470((String)metaValue.orElse("META_NOT_FOUND"));
        });
    }

    private void registerRandomPlayerPlaceholder() {
        PlaceholderHelper.withServer("random_player", (server, args) -> {
            List<class_3222> playerList = ServerHelper.getPlayers();
            class_3222 serverPlayerEntity = RandomUtil.drawList(playerList);
            return class_2561.method_43470((String)serverPlayerEntity.method_7334().getName());
        });
    }

    private void registerRandomPlaceholder() {
        PlaceholderHelper.withServer("random", (server, args) -> {
            int i;
            if (args == null) {
                return PlaceholderHelper.INVALID_TEXT;
            }
            String[] split = args.split(" ");
            if (split.length != 2) {
                return PlaceholderHelper.INVALID_TEXT;
            }
            try {
                i = RandomUtil.getRandom().nextInt(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
            }
            catch (Exception e) {
                return PlaceholderHelper.INVALID_TEXT;
            }
            return class_2561.method_43470((String)String.valueOf(i));
        });
    }

    private void registerHealthBarPlaceholder() {
        PlaceholderHelper.withPlayer("health_bar", player -> {
            int totalHearts = 10;
            int filledHearts = (int)(player.method_6032() / 2.0f);
            int unfilledHearts = totalHearts - filledHearts;
            String str = "\u2665".repeat(filledHearts) + "\u2661".repeat(unfilledHearts);
            return class_2561.method_43470((String)str);
        });
    }

    private void registerRotatePlaceholder() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"fuji", (String)"rotate"), (ctx, args) -> {
            String namespace = "default";
            if (ctx.player() != null) {
                namespace = ctx.player().method_7334().getName();
            }
            ROTATE_CACHE.putIfAbsent(namespace, new HashMap());
            Map<String, String> rotateMap = ROTATE_CACHE.get(namespace);
            rotateMap.putIfAbsent(args, args);
            String frame = rotateMap.get(args);
            rotateMap.put(args, StringUtils.rotate((String)frame, (int)-1));
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)frame));
        });
    }
}

