/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.top_chunks;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.top_chunks.config.model.TopChunksConfigModel;
import io.github.sakurawald.module.initializer.top_chunks.gui.TopChunksGui;
import io.github.sakurawald.module.initializer.top_chunks.structure.ChunkScore;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TopChunksInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<TopChunksConfigModel> config = new ObjectConfigurationHandler<TopChunksConfigModel>("config.json", TopChunksConfigModel.class);

    @CommandNode(value="chunks")
    @Document(value="List all chunks ordered by lag score.")
    private static int $chunks(@CommandSource class_2168 source) {
        CompletableFuture.runAsync(() -> {
            PriorityQueue<ChunkScore> PQ = new PriorityQueue<ChunkScore>();
            for (class_3218 world : ServerHelper.getWorlds()) {
                HashMap<class_1923, ChunkScore> topChunkReport = new HashMap<class_1923, ChunkScore>();
                for (class_1297 entity : world.method_27909()) {
                    class_1923 pos = entity.method_31476();
                    topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                    ((ChunkScore)topChunkReport.get(pos)).plusEntity(entity);
                }
                for (class_3193 chunkHolder : ServerHelper.getChunks(world)) {
                    class_2818 worldChunk = chunkHolder.method_16144();
                    if (worldChunk == null) continue;
                    for (class_2586 blockEntity : worldChunk.method_12214().values()) {
                        class_1923 pos = worldChunk.method_12004();
                        topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                        ((ChunkScore)topChunkReport.get(pos)).plusBlockEntity(blockEntity);
                    }
                }
                topChunkReport.values().forEach(chunkScore -> {
                    chunkScore.sum();
                    PQ.add((ChunkScore)chunkScore);
                });
            }
            TopChunksInitializer.sendTopChunksReport(source, PQ);
        });
        return 1;
    }

    private static void sendTopChunksReport(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        if (source.method_43737()) {
            TopChunksInitializer.sendTopChunksReportAsGui(source, PQ);
        } else {
            TopChunksInitializer.sendTopChunksReportAsMessage(source, PQ);
        }
    }

    private static void sendTopChunksReportAsGui(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        new TopChunksGui(source.method_44023(), PQ.stream().toList(), 0).open();
    }

    private static void sendTopChunksReportAsMessage(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        TopChunksConfigModel config = TopChunksInitializer.config.model();
        TopChunksInitializer.computeNearestPlayer(source, PQ, config.top.rows * config.top.columns);
        class_5250 reportText = class_2561.method_43473();
        block0: for (int j = 0; j < config.top.rows; ++j) {
            for (int i = 0; i < config.top.columns; ++i) {
                if (PQ.isEmpty()) break block0;
                reportText.method_10852(PQ.poll().asText(source)).method_10852(TextHelper.TEXT_SPACE);
            }
            reportText.method_10852(TextHelper.TEXT_NEWLINE);
        }
        source.method_45068((class_2561)reportText);
    }

    private static void computeNearestPlayer(class_2168 source, @NotNull PriorityQueue<ChunkScore> PQ, int topN) {
        int count = 0;
        for (ChunkScore chunkScore : PQ) {
            class_1923 chunkPos;
            class_2338 blockPos;
            if (count++ >= topN) break;
            class_3218 world = chunkScore.getDimension();
            class_1657 nearestPlayer = world.method_18459((double)(blockPos = (chunkPos = chunkScore.getChunkPos()).method_8323()).method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (double)TopChunksInitializer.config.model().nearest_distance, false);
            if (nearestPlayer == null) continue;
            chunkScore.getPlayers().add(TextHelper.getValueByKey(source, "top_chunks.prop.players.nearest", nearestPlayer.method_7334().getName()));
        }
    }
}

