/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.top_chunks.structure;

import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.structure.GlobalPos;
import io.github.sakurawald.core.structure.TypeFormatter;
import io.github.sakurawald.module.initializer.top_chunks.TopChunksInitializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ChunkScore
implements Comparable<ChunkScore> {
    private final class_3218 dimension;
    private final class_1923 chunkPos;
    private final Map<String, Integer> type2amount = new HashMap<String, Integer>();
    private int score;
    private final Set<String> players = new HashSet<String>();

    public ChunkScore(class_3218 dimension, class_1923 chunkPos) {
        this.dimension = dimension;
        this.chunkPos = chunkPos;
    }

    public static boolean canClickToTeleportToThisChunk(class_3222 player) {
        return player.method_64475(4) || PermissionHelper.hasPermission(player.method_5667(), "top_chunks.teleport");
    }

    public void plusEntity(@NotNull class_1297 entity) {
        String type = entity.method_5864().method_5882();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.players.add(PlayerHelper.getName((class_1657)player));
        }
    }

    public void plusBlockEntity(@NotNull class_2586 blockEntity) {
        String type = blockEntity.method_11010().method_26204().method_63499();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
    }

    public void sum() {
        this.score = 0;
        for (String type : this.type2amount.keySet()) {
            HashMap<String, Integer> type2score = TopChunksInitializer.config.model().type2score;
            this.score += type2score.getOrDefault(type, type2score.get("default")) * this.type2amount.get(type);
        }
    }

    @NotNull
    public String toString() {
        return String.format("%-5d", this.score);
    }

    @Override
    public int compareTo(@NotNull ChunkScore that) {
        return Integer.compare(that.score, this.score);
    }

    @NotNull
    public class_2561 asText(@NotNull class_2168 source) {
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.dimension", RegistryHelper.ofString((class_1937)this.dimension))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.chunk", this.computeChunkLocationString(source))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.score", this.score)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.players", this.players)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TypeFormatter.formatTypes(source, this.type2amount));
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.toString())).method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction((class_2561)hoverText)).method_27706(this.players.isEmpty() ? class_124.field_1080 : class_124.field_1077));
    }

    public String computeChunkLocationString(@NotNull class_2168 source) {
        String chunkLocation;
        if (TopChunksInitializer.config.model().hide_location) {
            chunkLocation = TextHelper.getValueByKey(source, "top_chunks.prop.hidden");
            if (source.method_9259(4)) {
                chunkLocation = TextHelper.getValueByKey(source, "top_chunks.prop.hidden.bypass", this.chunkPos.toString());
            }
        } else {
            chunkLocation = this.chunkPos.toString();
        }
        return chunkLocation;
    }

    public void teleportToThisChunk(class_3222 player) {
        class_2338 chunkCenterPos = new class_2338(this.chunkPos.method_33940(), 128, this.chunkPos.method_33942());
        int y = this.dimension.method_8598(class_2902.class_2903.field_13197, chunkCenterPos).method_10264();
        if (y == -64) {
            y = 128;
        }
        new GlobalPos((class_1937)this.dimension, (double)chunkCenterPos.method_10263(), (double)y, (double)chunkCenterPos.method_10260(), player.method_36454(), player.method_36455()).teleport(player);
    }

    public class_3218 getDimension() {
        return this.dimension;
    }

    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    public Map<String, Integer> getType2amount() {
        return this.type2amount;
    }

    public int getScore() {
        return this.score;
    }

    public Set<String> getPlayers() {
        return this.players;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkScore)) {
            return false;
        }
        ChunkScore other = (ChunkScore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        class_3218 this$dimension = this.getDimension();
        class_3218 other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        class_1923 this$chunkPos = this.getChunkPos();
        class_1923 other$chunkPos = other.getChunkPos();
        if (this$chunkPos == null ? other$chunkPos != null : !this$chunkPos.equals(other$chunkPos)) {
            return false;
        }
        Map<String, Integer> this$type2amount = this.getType2amount();
        Map<String, Integer> other$type2amount = other.getType2amount();
        if (this$type2amount == null ? other$type2amount != null : !((Object)this$type2amount).equals(other$type2amount)) {
            return false;
        }
        Set<String> this$players = this.getPlayers();
        Set<String> other$players = other.getPlayers();
        return !(this$players == null ? other$players != null : !((Object)this$players).equals(other$players));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChunkScore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScore();
        class_3218 $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        class_1923 $chunkPos = this.getChunkPos();
        result = result * 59 + ($chunkPos == null ? 43 : $chunkPos.hashCode());
        Map<String, Integer> $type2amount = this.getType2amount();
        result = result * 59 + ($type2amount == null ? 43 : ((Object)$type2amount).hashCode());
        Set<String> $players = this.getPlayers();
        result = result * 59 + ($players == null ? 43 : ((Object)$players).hashCode());
        return result;
    }
}

