/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.title.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.title.TitleInitializer;
import mod.fuji.module.initializer.title.service.TitleService;
import mod.fuji.module.initializer.title.structure.TitleDescriptor;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTitlesGui
extends PagedGui<TitleDescriptor> {
    public ListTitlesGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<TitleDescriptor> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "title.list.gui.title", new Object[0]), entities, pageIndex);
        this.drawInfoButton();
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "title.list.help.lore")));
        if (this.isViewingAllTitles(entities)) {
            GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 5, (GuiElementBuilder)GuiHelper.Button.makeLetterAButton().setName(TextHelper.getTextByKey(player, "entity.list.mine", new Object[0])).setCallback(() -> ListTitlesGui.makeInstance(player, TitleService.getObtainedTitles(player)).open()));
        } else {
            GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 5, (GuiElementBuilder)GuiHelper.Button.makeHeartButton().setName(TextHelper.getTextByKey(player, "entity.list.all", new Object[0])).setCallback(() -> ListTitlesGui.makeInstance(player, TitleService.getAllTitles()).open()));
        }
    }

    private void drawInfoButton() {
        class_3222 player = this.getPlayer();
        Optional<String> activeTitle = TitleService.getActiveTitle(player).map(TitleDescriptor::getDisplayName);
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 3, GuiHelper.Button.makeInfoButton(player).setLore(List.of(TextHelper.getTextByKey(player, "title.title.active", activeTitle.orElse(TitleService.getNoTitleActiveText())))));
    }

    private boolean isViewingAllTitles(@NotNull List<TitleDescriptor> entities) {
        return entities == TitleInitializer.config.model().getTitleDescriptors();
    }

    public static ListTitlesGui makeInstance(@NotNull class_3222 player, List<TitleDescriptor> entities) {
        return new ListTitlesGui(null, player, entities, 0);
    }

    @Override
    protected PagedGui<TitleDescriptor> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<TitleDescriptor> entities, int pageIndex) {
        return new ListTitlesGui(parent, player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull TitleDescriptor entity) {
        class_3222 player = this.getPlayer();
        GuiElementBuilder builder = GuiElementBuilder.from((class_1799)entity.toItemStack());
        builder.setName(TextHelper.getTextByValue(player, entity.getDisplayName(), new Object[0]));
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(player, "entity.obtained", TitleService.isTitleObtained(player, entity.getId()), entity.getId()));
        lore.addAll(TextHelper.getTextListByValue((Object)player, entity.getLore()));
        builder.setLore(lore);
        builder.setCallback(clickType -> {
            if (clickType.shift && clickType.isLeft) {
                Optional<TitleDescriptor> activeTitle = TitleService.getActiveTitle(player);
                activeTitle.ifPresent(descriptor -> {
                    TitleService.setActiveTitle(player, null);
                    TextHelper.sendTextByKey(player, "title.title.active.unset", descriptor.getDisplayName());
                    this.drawInfoButton();
                });
                return;
            }
            if (clickType.isLeft) {
                if (!TitleService.isTitleObtained(player, entity.getId())) {
                    TextHelper.sendTextByKey(player, "title.not_obtained", entity.getDisplayName());
                    return;
                }
                TitleService.setActiveTitle(player, entity.getId());
                this.drawInfoButton();
                TextHelper.sendTextByKey(player, "title.title.active.set", entity.getDisplayName());
                return;
            }
        });
        return builder.build();
    }
}

