/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.command.structure;

import java.util.Optional;
import lombok.Generated;
import mod.fuji.core.command.annotation.CommandRequirement;
import org.jetbrains.annotations.Nullable;

public class CommandRequirementDescriptor {
    private int level = 4;
    @Nullable
    private String string;

    public CommandRequirementDescriptor(int level, @Nullable String string) {
        this.level = level;
        this.string = Optional.ofNullable(string).filter(it -> !it.isBlank()).orElse(null);
    }

    @Nullable
    public static CommandRequirementDescriptor from(@Nullable CommandRequirement annotation) {
        if (annotation == null) {
            return null;
        }
        return new CommandRequirementDescriptor(annotation.level(), annotation.string());
    }

    public static boolean isEmptyRequirement(@Nullable CommandRequirementDescriptor commandRequirement) {
        if (commandRequirement == null) {
            return true;
        }
        return commandRequirement.level == 0 && commandRequirement.string == null;
    }

    public static int getInitialLevel() {
        return 0;
    }

    public static String getInitialString() {
        return null;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Nullable
    @Generated
    public String getString() {
        return this.string;
    }

    @Generated
    public CommandRequirementDescriptor setLevel(int level) {
        this.level = level;
        return this;
    }

    @Generated
    public CommandRequirementDescriptor setString(@Nullable String string) {
        this.string = string;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandRequirementDescriptor)) {
            return false;
        }
        CommandRequirementDescriptor other = (CommandRequirementDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        String this$string = this.getString();
        String other$string = other.getString();
        return !(this$string == null ? other$string != null : !this$string.equals(other$string));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandRequirementDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommandRequirementDescriptor(level=" + this.getLevel() + ", string=" + this.getString() + ")";
    }

    @Generated
    public CommandRequirementDescriptor() {
    }
}

