/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_cooldown;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.GreedyCommandString;
import mod.fuji.core.command.argument.wrapper.impl.StringList;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.command.CommandExecutionPreEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_cooldown.CommandCooldownPlaceholders;
import mod.fuji.module.initializer.command_cooldown.config.model.CommandCooldownConfigModel;
import mod.fuji.module.initializer.command_cooldown.config.model.NamedCooldownDataModel;
import mod.fuji.module.initializer.command_cooldown.config.transformer.NamedCooldownSchemaV1Transformer;
import mod.fuji.module.initializer.command_cooldown.service.NamedCooldownService;
import mod.fuji.module.initializer.command_cooldown.service.UnnamedCooldownService;
import mod.fuji.module.initializer.command_cooldown.structure.NamedCooldownDataNode;
import mod.fuji.module.initializer.command_cooldown.structure.NamedCooldownDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826375815L, value="This module allows defining a `cooldown` after command execution.\n")
@ColorBoxes(value={@ColorBox(id=1751902763633L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 There are 2 types of `cooldown`.\n1. `Unnamed Cooldown`\nYou can use it to define a `cooldown duration` for a specified command. (It is `tested` and managed automatically)\nA `unnamed cooldown` will not be `persisted` on the server shutdown.\nIts typical use is to define a `cooling duration` for a specified command.\nAnd a `unnamed cooldown` will be `tested` <green>automatically</green> when a player executes a command.\nFor example: define a `3 seconds` cooling duration for `/back` command.\nTo define a `unnamed cooldown`, you need to modify the config file, and issue `/fuji reload` command to apply it.\n\n2. `Named Cooldown`\nYou have to use commands to create a `named cooldown`, and use commands to `test` it.\nA `named cooldown` will be `persisted` on the server shutdown.\nIts typical use is to define a `named cooldown`, and `associate` it with `arbitrary command instance`.\nFor example, you have to use `/command-cooldown create` to `create` a `named cooldown`.\nThen, you have to use `/command-cooldown test` to `test` a `named cooldown` <green>manually</green>.\nYou have to specify the `failure case commands` and `success case commands` when `testing` a `named cooldown`.\nIf the `conditions` defined by the `named cooldown` is satisfied, then it is a `success case`, else it is a `failure case`.\nFor `success case`, we will execute `the success case command`.\nFor `failure case`, we will execute `the failure case command`.\n\n<green>TL;DR: If you only want to define a simple `cooling duration` for a specified command, just use `unnamed cooldown`.\n"), @ColorBox(id=1751902885278L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `named cooldown`. (With 3 seconds `cooldown duration`.)\nIssue: `/command-cooldown create kitfood 3000`\n\n\u25c9 Test a `named cooldown` with `arbitrary command instance`.\nIssue: `/command-cooldown test kitfood Alice say Used successfully once`.\nThis command will `test` the specified `named cooldown`:\n1. If the result is `the success case`, then it will execute `/say Used successfully once`.\n2. If the result is `the failure case`, then it will do nothing.\n\nIssue: `/command-cooldown test kitfood Alice --onFailed \"say false\" say true`\nThis command will `test` the specified `named cooldown`:\n1. If the result is `the success case`, then it will execute `/say true`.\n2. If the result is `the failure case`, then it will execute `/say false`.\n\n<green>TIP: You can insert `%fuji:command_cooldown_left_time kitfood%` placeholder to display the remaining duration.\n<green>TIP: To specify `more than 1 command` in the `the success command` or `the failure command` place, you can use `chain` module.\n\n\u25c9 Test a `named cooldown` with `pre-defined command instance`.\nYou can `pre-define` the `success case commands` and `failure case commands` in the config file.\nAnd use `/command-cooldown try-use kitfood Alice` to `test` it.\nThis method is much more brief.\n\n\u25c9 Reset a `named cooldown` for a player.\nIssue: `/command-cooldown reset kitfood Alice`\n\n\u25c9 Create a `named cooldown`. (With 15 seconds `cooldown duration`, and `limit of number of use` is 3)\nIssue: `/command-cooldown create kitfood 15000 --maxUses 3`\n\n\u25c9 Create a global `named cooldown`.\nBy default, a `named cooldown` applies `per-player`.\nA `global` named cooldown applies `per-server`.\nIssue: `/command-cooldown create kitfood 3000 --global true`\n"), @ColorBox(id=1751903262817L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Make a `non-persistent named cooldown`.\nBy default, a `named cooldown` will be `persisted` on the `storage`.\nHowever, you can create a `non-persist named cooldown`.\nIssue: `/command-cooldown create kitfood 999999999999 --persistent false`\nThis cooldown says that, it can be used only once after each server re-start.\n")})
@CommandNode(value="command-cooldown")
@CommandRequirement(level=4)
public class CommandCooldownInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandCooldownConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandCooldownConfigModel.class).installTransformer(new NamedCooldownSchemaV1Transformer());
    public static final BaseConfigurationHandler<NamedCooldownDataModel> namedCooldownData = ObjectConfigurationHandler.ofModule("named-cooldown-data.json", NamedCooldownDataModel.class).addPreMappingModelIntoJsonObjectHook(model -> model.getNodes().stream().filter(it -> it.getDescriptor() != null && !it.getDescriptor().isPersistent()).forEach(it -> it.getCooldown().getTimestamp().clear())).enableAutoSaveFeature();

    @Document(id=1751826400837L, value="Create a named-cooldown.")
    @CommandNode(value="create")
    private static int $create(@CommandSource class_2168 source, String name, long cooldownDuration, Optional<Integer> maxUses, Optional<Boolean> persistent, Optional<Boolean> global) {
        return NamedCooldownService.findNamedCooldownDescriptor(name).map(it -> {
            TextHelper.sendTextByKey(source, "command_cooldown.already_exists", name);
            return 0;
        }).orElseGet(() -> {
            int $maxUses = maxUses.orElse(Integer.MAX_VALUE);
            Boolean $persistent = persistent.orElse(true);
            Boolean $global = global.orElse(false);
            NamedCooldownService.createNamedCooldownDescriptor(name, cooldownDuration, $maxUses, $persistent, $global);
            TextHelper.sendTextByKey(source, "command_cooldown.created", name);
            return 1;
        });
    }

    @Document(id=1751826416666L, value="Delete a named-cooldown.")
    @CommandNode(value="delete")
    private static int $delete(@CommandSource class_2168 source, NamedCooldownDescriptor namedCooldown, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            NamedCooldownService.deleteNamedCooldownDescriptor(namedCooldown);
            TextHelper.sendTextByKey(source, "command_cooldown.deleted", namedCooldown.getName());
            return 1;
        });
    }

    @Document(id=1756539191422L, value="List all `unnamed-cooldown` and `named-cooldown`.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        TextHelper.sendTextByKey(source, "command_cooldown.list.unnamed_cooldown", UnnamedCooldownService.listUnnamedCooldowns().keySet());
        TextHelper.sendMessageByText(source, (class_2561)TextHelper.Formatter.formatMapMultiLine(UnnamedCooldownService.listUnnamedCooldowns()));
        TextHelper.sendMessageByText(source, TextHelper.TEXT_EMPTY);
        TextHelper.sendTextByKey(source, "command_cooldown.list.named_cooldown", NamedCooldownService.getNamedCooldownDescriptors().keySet());
        return 1;
    }

    @Document(id=1751826379596L, value="Test a named-cooldown with `arbitrary command instance`, and execute `success case command` or `failure case command`.")
    @CommandNode(value="test")
    private static int $test(@CommandSource class_2168 source, NamedCooldownDescriptor namedCooldown, class_3222 player, Optional<StringList> onFailed, GreedyCommandString onSuccess) {
        StringList $onFailed = onFailed.orElse(new StringList(Collections.emptyList()));
        List<String> onSuccessCommands = Collections.singletonList((String)onSuccess.getValue());
        List onFailureCommands = (List)$onFailed.getValue();
        return NamedCooldownService.testNamedCooldown(namedCooldown, player, onSuccessCommands, onFailureCommands);
    }

    @Document(id=1752917170907L, value="Test a named-cooldown with `pre-defined command instance`, and execute `success case command` or `failure case command`.")
    @CommandNode(value="try-use")
    private static int $tryUse(@CommandSource class_2168 source, NamedCooldownDescriptor namedCooldown, class_3222 player) {
        List<String> onSuccessCommands = namedCooldown.getTryUse().getOnSuccessCommands();
        List<String> onFailureCommands = namedCooldown.getTryUse().getOnFailureCommands();
        return NamedCooldownService.testNamedCooldown(namedCooldown, player, onSuccessCommands, onFailureCommands);
    }

    @Document(id=1751826420385L, value="Reset `the last use time` of a named-cooldown for a player.")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource class_2168 source, NamedCooldownDescriptor namedCooldown, class_3222 player) {
        String key = NamedCooldownDataNode.toKey(player);
        NamedCooldownService.resetNamedCooldownDuration(namedCooldown, key);
        TextHelper.sendTextByKey(source, "command_cooldown.reset", key, namedCooldown.getName());
        return 1;
    }

    @Override
    protected void registerPlaceholders() {
        CommandCooldownPlaceholders.registerCommandCooldownLeftTimePlaceholder();
        CommandCooldownPlaceholders.registerCommandCooldownLeftTimeDatePlaceholder();
        CommandCooldownPlaceholders.registerCommandCooldownLeftUsagePlaceholder();
    }

    @EventConsumer(injectorPriority=0, consumerPriority=999)
    @TestCase(action="Test the compatibility with other modules.", targets={"Issue `/heal` command twice, the `command warmup` should be performed first, then the `command cooldown`", "Issue `/run as player @s heal` command twice, the command cooldown should be performed."})
    private static void consumeCommandExecutionPreEvent(CommandExecutionPreEvent event) {
        String commandString;
        if (event.getCallback().isCancelled()) {
            return;
        }
        class_2168 commandSource = event.getCommandSource();
        if (CommandHelper.Source.isExecutedByConsole(commandSource)) {
            return;
        }
        if (config.model().isAdminPlayersCanBypass() && CommandHelper.Requirement.isAdmin(commandSource)) {
            return;
        }
        @NotNull class_3222 player = Objects.requireNonNull(commandSource.method_44023());
        long remainingDuration = UnnamedCooldownService.computeRemainingUnnamedCooldownDuration(player, commandString = event.getCommandString());
        if (remainingDuration > 0L) {
            long remainingDurationInSecond = remainingDuration / 1000L;
            TextHelper.sendTextByKey(player, "command_cooldown.cooldown", remainingDurationInSecond);
            event.getCallback().cancel();
        }
    }
}

