/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.mixin.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.CompletableFuture;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.module.initializer.skin.service.SkinService;
import net.minecraft.class_3248;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    private GameProfile field_45029;
    @Unique
    CompletableFuture<Property> skinFuture;

    @Inject(method={"tickVerify"}, at={@At(value="HEAD")}, cancellable=true)
    public void postponeTheLoginUntilTheSkinFetchingIsComplete(@NotNull CallbackInfo ci) {
        if (this.skinFuture == null) {
            this.skinFuture = CompletableFuture.supplyAsync(() -> SkinService.getEffectiveSkin(this.field_45029));
        }
        if (!this.skinFuture.isDone()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendSuccessPacket"}, at={@At(value="HEAD")})
    void applyTheFetchedSkin(@NotNull GameProfile gameProfile, CallbackInfo ci) {
        if (this.skinFuture == null) {
            LogUtil.warn("Failed to modify the skin property for player {}. (It seems like the tickVerify() method is modified by other mods.)", AuthlibHelper.getName(this.field_45029));
            return;
        }
        Property valueIfAbsent = SkinService.getPreferredDefaultSkin();
        AuthlibHelper.modifyGameProfile(this.field_45029, this.skinFuture.getNow(valueIfAbsent));
    }
}

