/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.config.mapper.wrapper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.config.mapper.wrapper.PropertyWrapper;
import org.jetbrains.annotations.NotNull;

public class PropertyMapWrapper {
    private Multimap<String, PropertyWrapper> properties;

    @NotNull
    public static PropertyMapWrapper fromVanillaType(@NotNull PropertyMap vanilla) {
        HashMultimap map = HashMultimap.create();
        for (String key : vanilla.keySet().stream().toList()) {
            for (Property property : vanilla.get((Object)key)) {
                map.put((Object)key, (Object)PropertyWrapper.fromVanillaType(property));
            }
        }
        return new PropertyMapWrapper((Multimap<String, PropertyWrapper>)map);
    }

    @NotNull
    public PropertyMap toVanillaType() {
        HashMultimap map = HashMultimap.create();
        if (this.properties != null) {
            for (Map.Entry entry : this.properties.entries()) {
                map.put((Object)((String)entry.getKey()), (Object)((PropertyWrapper)entry.getValue()).toVanillaType());
            }
        }
        return AuthlibHelper.makePropertyMap((Multimap<String, Property>)map);
    }

    @Generated
    public Multimap<String, PropertyWrapper> getProperties() {
        return this.properties;
    }

    @Generated
    public PropertyMapWrapper setProperties(Multimap<String, PropertyWrapper> properties) {
        this.properties = properties;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyMapWrapper)) {
            return false;
        }
        PropertyMapWrapper other = (PropertyMapWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Multimap<String, PropertyWrapper> this$properties = this.getProperties();
        Multimap<String, PropertyWrapper> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyMapWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<String, PropertyWrapper> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PropertyMapWrapper(properties=" + String.valueOf(this.getProperties()) + ")";
    }

    @Generated
    public PropertyMapWrapper() {
    }

    @Generated
    public PropertyMapWrapper(Multimap<String, PropertyWrapper> properties) {
        this.properties = properties;
    }

    public static class PropertyMapWrapperAdapter
    implements JsonSerializer<PropertyMapWrapper>,
    JsonDeserializer<PropertyMapWrapper> {
        private static final String NAME_KEY = "name";
        private static final String VALUE_KEY = "value";
        private static final String SIGNATURE_KEY = "signature";

        public JsonElement serialize(@NotNull PropertyMapWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            if (src.getProperties() != null) {
                for (PropertyWrapper wrapper : src.getProperties().values()) {
                    JsonObject object = new JsonObject();
                    object.addProperty(NAME_KEY, wrapper.getName());
                    object.addProperty(VALUE_KEY, wrapper.getValue());
                    if (wrapper.getSignature() != null) {
                        object.addProperty(SIGNATURE_KEY, wrapper.getSignature());
                    }
                    result.add((JsonElement)object);
                }
            }
            return result;
        }

        public PropertyMapWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMultimap map;
            block4: {
                block3: {
                    map = HashMultimap.create();
                    if (!json.isJsonObject()) break block3;
                    JsonObject object = json.getAsJsonObject();
                    for (Map.Entry entry : object.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                        for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            map.put((Object)((String)entry.getKey()), (Object)PropertyMapWrapperAdapter.parseProperty((String)entry.getKey(), element.getAsJsonObject()));
                        }
                    }
                    break block4;
                }
                if (!json.isJsonArray()) break block4;
                for (JsonElement element : json.getAsJsonArray()) {
                    JsonObject obj = element.getAsJsonObject();
                    String name = obj.getAsJsonPrimitive(NAME_KEY).getAsString();
                    map.put((Object)name, (Object)PropertyMapWrapperAdapter.parseProperty(name, obj));
                }
            }
            return new PropertyMapWrapper((Multimap<String, PropertyWrapper>)map);
        }

        @NotNull
        private static PropertyWrapper parseProperty(String name, JsonObject obj) {
            String value = obj.getAsJsonPrimitive(VALUE_KEY).getAsString();
            String signature = obj.has(SIGNATURE_KEY) ? obj.getAsJsonPrimitive(SIGNATURE_KEY).getAsString() : null;
            return new PropertyWrapper(name, value, signature);
        }
    }
}

