/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.top_chunks;

import java.util.PriorityQueue;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.top_chunks.config.model.TopChunksConfigModel;
import mod.fuji.module.initializer.top_chunks.gui.TopChunksGui;
import mod.fuji.module.initializer.top_chunks.service.TopChunksService;
import mod.fuji.module.initializer.top_chunks.structure.ChunkScore;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Document(id=1751826535209L, value="Analyze all loaded chunks of the server, and find the most lagged chunks.\n")
@ColorBox(id=1751981000562L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nThis module use a `simple statistical method` to estimate the `degree of lag of a chunk`.\nThe method is simple, it simply counts the `entities` and `block entities` inside a `chunk`.\nAnd sum up the `score` by the `type` of `entity` or `block entity`.\n\nIt's simple, fast and useful.\nYou can define the score of `a zombie` as `4`.\nThe score of `a bee` as `15`.\nAnd the score of `a piston` as `10`.\nThat depends on your case.\nSimple method often works.\n")
public class TopChunksInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<TopChunksConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", TopChunksConfigModel.class);

    @Document(id=1753056668984L, value="An alias command to `/chunks message`.")
    @CommandNode(value="chunks")
    private static int $chunks(@CommandSource class_2168 source) {
        return TopChunksInitializer.$message(source);
    }

    @Document(id=1751826537195L, value="List all chunks ordered by lag score, and send in `message`.")
    @CommandNode(value="chunks message")
    private static int $message(@CommandSource class_2168 source) {
        PriorityQueue<ChunkScore> PQ = TopChunksService.computeChunkScores(source);
        TopChunksConfigModel config1 = config.model();
        class_5250 reportText = class_2561.method_43473();
        block0: for (int j = 0; j < config1.top.rows; ++j) {
            for (int i = 0; i < config1.top.columns; ++i) {
                if (PQ.isEmpty()) break block0;
                reportText.method_10852(PQ.poll().toText(source)).method_10852(TextHelper.TEXT_SPACE);
            }
            reportText.method_10852(TextHelper.TEXT_NEWLINE);
        }
        TextHelper.sendMessageByText(source, (class_2561)reportText);
        return 1;
    }

    @Document(id=1753056643919L, value="List all chunks ordered by lag score, and send in `GUI`.")
    @CommandNode(value="chunks gui")
    private static int $gui(@CommandSource class_2168 source) {
        PriorityQueue<ChunkScore> PQ = TopChunksService.computeChunkScores(source);
        new TopChunksGui(source.method_44023(), PQ.stream().toList(), 0).open();
        return 1;
    }
}

