/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.structure.Pair;
import mod.fuji.module.initializer.world.manager.accessor.ExtendedDimensionOptions;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.ChunkGeneratorType;
import mod.fuji.module.initializer.world.manager.service.FlatPresetParser;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimension;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionProperties;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2881;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3232;
import net.minecraft.class_4543;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7145;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeDimensionMaker {
    public static Pair<class_3218, class_5363> makeRuntimeDimension(@NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        MinecraftServer server = ServerHelper.getServer();
        RuntimeDimensionProperties worldProperties = RuntimeDimensionMaker.makeWorldProperties(runtimeDimensionDescriptor);
        @Nullable class_5363 dimensionOptions = RuntimeDimensionMaker.makeDimensionOptions(runtimeDimensionDescriptor);
        ((ExtendedDimensionOptions)dimensionOptions).fuji$setSaveDimensionOptions(false);
        class_2960 dimensionIdentifier = RegistryHelper.makeIdentifierOrThrow(runtimeDimensionDescriptor.dimension);
        class_5321 worldRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionIdentifier);
        RuntimeDimension dimension = new RuntimeDimension(server, (Executor)class_156.method_18349(), server.field_23784, (class_5268)worldProperties, (class_5321<class_1937>)worldRegistryKey, dimensionOptions, runtimeDimensionDescriptor.isDebugWorld(), class_4543.method_27984((long)runtimeDimensionDescriptor.seed), (List<class_5304>)ImmutableList.of(), runtimeDimensionDescriptor.shouldTickTime, RuntimeDimensionMaker.makeRandomSequenceState(runtimeDimensionDescriptor));
        RuntimeDimensionMaker.postRuntimeDimensionMake(dimension, runtimeDimensionDescriptor);
        return new Pair<class_3218, class_5363>(dimension, dimensionOptions);
    }

    @NotNull
    private static RuntimeDimensionProperties makeWorldProperties(@NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        MinecraftServer server = ServerHelper.getServer();
        return new RuntimeDimensionProperties(server.method_27728(), runtimeDimensionDescriptor);
    }

    @NotNull
    private static class_8565 makeRandomSequenceState(@NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        long seed = runtimeDimensionDescriptor.seed;
        return new class_8565(seed);
    }

    private static void postRuntimeDimensionMake(class_3218 dimension, @NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        if (class_7134.field_37672.toString().equals(runtimeDimensionDescriptor.dimension_type)) {
            dimension.method_51837(new class_2881(dimension, dimension.method_8412(), class_2881.class_8576.field_44946));
        }
    }

    @NotNull
    private static class_5363 makeDimensionOptions(RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        if (runtimeDimensionDescriptor.worldPresetType != null) {
            return RuntimeDimensionMaker.makeDimensionOptionsWithWorldPreset(runtimeDimensionDescriptor);
        }
        return RuntimeDimensionMaker.makeDimensionOptionsWithCustomization(runtimeDimensionDescriptor);
    }

    @NotNull
    private static class_5363 makeDimensionOptionsWithWorldPreset(RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        class_2378 worldPresetRegistry = RegistryHelper.getRegistry(class_7924.field_41250);
        assert (runtimeDimensionDescriptor.worldPresetType != null);
        class_5321<class_7145> worldPresetKey = runtimeDimensionDescriptor.worldPresetType.toWorldPresetKey();
        class_7145 worldPreset = (class_7145)worldPresetRegistry.method_29107(worldPresetKey);
        if (worldPreset == null) {
            throw new RuntimeException("Failed to make DimensionOptions for dimension %s, the WorldPreset didn't existed in the registry.".formatted(runtimeDimensionDescriptor.dimension));
        }
        Optional overworldDimensionOptionsOptional = worldPreset.method_41584();
        if (overworldDimensionOptionsOptional.isEmpty()) {
            throw new RuntimeException("Failed to make DimensionOptions for dimension %s, the WorldPreset#getOverworld() returns null.".formatted(runtimeDimensionDescriptor.dimension));
        }
        return (class_5363)overworldDimensionOptionsOptional.get();
    }

    @NotNull
    private static class_5363 makeDimensionOptionsWithCustomization(RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        class_6880<class_2874> dimensionTypeEntry = RuntimeDimensionMaker.makeDimensionTypeEntry(runtimeDimensionDescriptor);
        class_2794 chunkGenerator = RuntimeDimensionMaker.makeChunkGenerator(runtimeDimensionDescriptor);
        return new class_5363(dimensionTypeEntry, chunkGenerator);
    }

    @NotNull
    private static class_2794 makeChunkGenerator(RuntimeDimensionDescriptor dimensionDescriptor) {
        if (dimensionDescriptor.chunkGeneratorType == ChunkGeneratorType.NOISE) {
            return RuntimeDimensionMaker.makeNoiseChunkGenerator(dimensionDescriptor);
        }
        if (dimensionDescriptor.chunkGeneratorType == ChunkGeneratorType.FLAT) {
            return RuntimeDimensionMaker.makeFlatChunkGenerator(dimensionDescriptor);
        }
        throw new RuntimeException("Failed to make the chunk generator for dimension %s.".formatted(dimensionDescriptor.dimension));
    }

    @NotNull
    private static class_2794 makeNoiseChunkGenerator(RuntimeDimensionDescriptor dimensionDescriptor) {
        class_2960 dimensionTypeIdentifier;
        class_2378 dimensionRegistry = RegistryHelper.getRegistry(class_7924.field_41224);
        @Nullable class_5363 existedDimensionOptions = (class_5363)dimensionRegistry.method_63535(dimensionTypeIdentifier = RegistryHelper.makeIdentifierOrThrow(dimensionDescriptor.dimension_type));
        if (existedDimensionOptions == null) {
            LogUtil.warn("Failed to make chunk generator for {}, there is no existed DimensionOptions for dimension type {}. Falling back to the `FlatChunkGenerator`.", dimensionDescriptor.getDimension(), dimensionTypeIdentifier);
            return RuntimeDimensionMaker.makeFlatChunkGenerator(dimensionDescriptor);
        }
        return existedDimensionOptions.comp_1013();
    }

    @NotNull
    private static class_6880<class_2874> makeDimensionTypeEntry(RuntimeDimensionDescriptor dimensionDescriptor) {
        class_2960 dimensionTypeIdentifier = RegistryHelper.makeIdentifierOrThrow(dimensionDescriptor.dimension_type);
        Optional dimensionTypeEntryOptional = RegistryHelper.getRegistryEntry(class_7924.field_41241, dimensionTypeIdentifier);
        if (dimensionTypeEntryOptional.isEmpty()) {
            throw new RuntimeException("Failed to make RegistryEntry<DimensionType> for dimension %s: The Optional<RegistryEntry<DimensionType>> null.".formatted(dimensionTypeIdentifier));
        }
        class_6880 dimensionTypeRegistryEntry = dimensionTypeEntryOptional.get();
        if (dimensionTypeRegistryEntry.comp_349() == null) {
            throw new RuntimeException("Failed to make RegistryEntry<DimensionType> for dimension %s: The value of RegistryEntry<DimensionType>.comp_349() is null.".formatted(dimensionTypeIdentifier));
        }
        return dimensionTypeRegistryEntry;
    }

    @NotNull
    private static class_2897 makeFlatChunkGenerator(RuntimeDimensionDescriptor dimensionDescriptor) {
        class_7871 biomeLookup = RegistryHelper.getRegistryEntryLookup(class_7924.field_41236);
        class_7871 structureSetLookup = RegistryHelper.getRegistryEntryLookup(class_7924.field_41248);
        class_7871 placedFeatureLookup = RegistryHelper.getRegistryEntryLookup(class_7924.field_41245);
        class_3232 flatChunkGeneratorConfig = class_3232.method_14309(biomeLookup, structureSetLookup, placedFeatureLookup);
        String presetString = dimensionDescriptor.chunkGeneratorParameters;
        if (presetString != null && !presetString.isBlank()) {
            class_7871 blockLookup = RegistryHelper.getRegistryEntryLookup(class_7924.field_41254);
            flatChunkGeneratorConfig = FlatPresetParser.parsePresetString(blockLookup, biomeLookup, structureSetLookup, placedFeatureLookup, presetString, flatChunkGeneratorConfig);
        }
        return new class_2897(flatChunkGeneratorConfig);
    }
}

