/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.random_teleport.searcher;

import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.service.random_teleport.filter.PositionFilter;
import mod.fuji.core.service.random_teleport.searcher.PositionYDownTopSearcher;
import mod.fuji.core.service.random_teleport.searcher.PositionYTopDownSearcher;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_7134;
import org.jetbrains.annotations.NotNull;

public abstract class PositionYSearcher {
    @NotNull
    public abstract Optional<Integer> search(@NotNull class_2791 var1, int var2, int var3);

    @NotNull
    public static PositionYSearcher forWorld(@NotNull class_3218 world) {
        Optional dimensionTypeRegistryKey = world.method_40134().method_40230();
        return dimensionTypeRegistryKey.map(it -> {
            if (it == class_7134.field_37666 || it == class_7134.field_37668) {
                return new PositionYTopDownSearcher();
            }
            if (it == class_7134.field_37667) {
                return new PositionYDownTopSearcher();
            }
            return null;
        }).orElseGet(PositionYTopDownSearcher::new);
    }

    @NotNull
    public static Optional<Integer> search(@NotNull class_2791 chunk, int blockPosX, int blockPosZ, @NotNull class_2350 direction) {
        int maxY;
        int minY = WorldHelper.getBottomYInclusive(chunk);
        if (minY >= (maxY = WorldHelper.getMaxBlockY(chunk))) {
            return Optional.empty();
        }
        int PLAYER_HEIGHT = 2;
        int initialBlockY = (direction == class_2350.field_11033 ? maxY : minY) + 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(blockPosX, initialBlockY, blockPosZ);
        class_2680 blockState1 = chunk.method_8320((class_2338)mutableBlockPos);
        class_2680 blockState2 = chunk.method_8320((class_2338)mutableBlockPos.method_10098(direction));
        if (direction == class_2350.field_11033) {
            while (mutableBlockPos.method_10264() > minY) {
                class_2680 blockState3 = chunk.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                if (!blockState3.method_26215() && blockState2.method_26215() && blockState1.method_26215() && PositionFilter.isSafeBlock(blockState3)) {
                    return Optional.of(mutableBlockPos.method_10264() + 1);
                }
                blockState1 = blockState2;
                blockState2 = blockState3;
            }
        } else {
            while (mutableBlockPos.method_10264() < maxY) {
                class_2680 blockState3 = chunk.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                if (!blockState1.method_26215() && blockState2.method_26215() && blockState3.method_26215() && PositionFilter.isSafeBlock(blockState1)) {
                    return Optional.of(mutableBlockPos.method_10264() - 1);
                }
                blockState1 = blockState2;
                blockState2 = blockState3;
            }
        }
        return Optional.empty();
    }
}

