/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import lombok.Generated;
import mod.fuji.core.document.annotation.TestCase;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@TestCase(action="Consider the possible runtime environments.", targets={"The fabric server-side environment.", "The fabric client-side environment.", "The neo-forge server-side environment. (With `sinytra-connector` mod)", "The neo-forge client-side environment. (With `sinytra-connector` mod)", "The hybrid server (forge+bukkit) with `sinytra-connector` mod", "The GraalVM native image. (Which invalidates the reflection)"})
public class ServerHelper {
    private static MinecraftServer server;

    public static void executeSync(Runnable runnable) {
        ServerHelper.getServer().method_40000(runnable);
    }

    @Generated
    public static MinecraftServer getServer() {
        return server;
    }

    @Generated
    public static void setServer(MinecraftServer server) {
        ServerHelper.server = server;
    }

    public static class ModInfo {
        @NotNull
        public static ModContainer getSelfModContainer() {
            return (ModContainer)FabricLoader.getInstance().getModContainer("fuji").orElseThrow(() -> new IllegalStateException("Failed to get 'fuji' mod container."));
        }
    }

    public static class Environment {
        public static boolean isClientSideIntegratedServer() {
            return Environment.getPhysicalEnvironmentType() == EnvType.CLIENT;
        }

        public static boolean isServerSideDedicatedServer() {
            return Environment.getPhysicalEnvironmentType() == EnvType.SERVER;
        }

        @NotNull
        public static EnvType getPhysicalEnvironmentType() {
            return FabricLoader.getInstance().getEnvironmentType();
        }

        public static void withDevelopmentEnvironment(@NotNull Runnable runnable) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                runnable.run();
            }
        }
    }

    public static class Lifecycle {
        public static boolean isServerInstantiated() {
            return server != null;
        }

        public static void withServerInstantiated(Runnable runnable) {
            if (Lifecycle.isServerInstantiated()) {
                runnable.run();
            }
        }
    }
}

