/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.command_callback;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.command.CommandRegistrationEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.service.command_callback.structure.TTLMap;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class CommandCallbackManager {
    private static final String COMMAND_CALLBACK_LITERAL = "command-callback";
    private static final String COMMAND_CALLBACK_UUID_ARGUMENT_NAME = "uuid";
    private static TTLMap<String, Consumer<class_3222>> uuid2consumer;

    @EventConsumer
    private static void resetCallbackMap(@Unused ServerStartedEvent event) {
        uuid2consumer = new TTLMap();
    }

    @EventConsumer
    private static void registerCommandCallbackCommand(CommandRegistrationEvent event) {
        CommandDispatcher<class_2168> dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_CALLBACK_LITERAL).then(class_2170.method_9244((String)COMMAND_CALLBACK_UUID_ARGUMENT_NAME, (ArgumentType)StringArgumentType.greedyString()).executes(CommandCallbackManager::$commandCallback)));
    }

    private static int $commandCallback(@NotNull CommandContext<class_2168> ctx) {
        return CommandHelper.Pattern.withServerPlayerCommand((class_2168)ctx.getSource(), player -> {
            String uuid = StringArgumentType.getString((CommandContext)ctx, (String)COMMAND_CALLBACK_UUID_ARGUMENT_NAME);
            CommandCallbackManager.invokeCallbackWithPlayer(uuid, player);
            return 1;
        });
    }

    private static void invokeCallbackWithPlayer(@NotNull String uuid, @NotNull class_3222 player) {
        Consumer<class_3222> consumer = uuid2consumer.get(uuid);
        if (consumer == null) {
            TextHelper.sendTextByKey(player, "callback.invalid", new Object[0]);
            return;
        }
        consumer.accept(player);
    }

    @NotNull
    private static String makeCallbackCommandString(@NotNull String uuid, @NotNull Consumer<class_3222> callback, long ttl, @NotNull TimeUnit timeUnit) {
        LogUtil.debug("Make callback command: uuid = {}", uuid);
        uuid2consumer.put(uuid, callback, ttl, timeUnit);
        return "/command-callback " + uuid;
    }

    @NotNull
    public static String makeCallbackCommandString(@NotNull Consumer<class_3222> callback, long ttl, @NotNull TimeUnit timeUnit) {
        return CommandCallbackManager.makeCallbackCommandString(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }

    @NotNull
    private static class_2558 makeCallbackClickEvent(@NotNull String uuid, @NotNull Consumer<class_3222> callback, long ttl, @NotNull TimeUnit timeUnit) {
        String commandString = CommandCallbackManager.makeCallbackCommandString(uuid, callback, ttl, timeUnit);
        return TextHelper.Events.ClickEvent.makeRunCommandAction(commandString);
    }

    @NotNull
    public static class_2558 makeCallbackClickEvent(@NotNull Consumer<class_3222> callback, long ttl, @NotNull TimeUnit timeUnit) {
        return CommandCallbackManager.makeCallbackClickEvent(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }
}

