/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.doctor.analyzer;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.fuji.module.initializer.doctor.analyzer.ExceptionAnalyzer;
import org.jetbrains.annotations.NotNull;

public class GenericModMixinApplicationExceptionAnalyzer
extends ExceptionAnalyzer {
    @Override
    @NotNull
    protected Pattern makePattern() {
        return Pattern.compile("mixins.json:(.+?)\\s+?from\\s+?mod\\s+?(.+?)\\b");
    }

    @Override
    public Optional<String> analyze(@NotNull List<Throwable> throwableChain, @NotNull String causeChain) {
        StringBuilder diagnosisBuilder = new StringBuilder();
        Matcher matcher = this.getPattern().matcher(causeChain);
        while (matcher.find()) {
            String mixinName = matcher.group(1);
            String modName = matcher.group(2);
            diagnosisBuilder.append("- [Reason] Failed to apply the mixin '%s' from mod '%s'.".formatted(mixinName, modName)).append(System.lineSeparator());
        }
        return Optional.of(diagnosisBuilder.toString());
    }
}

