/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.doctor.analyzer;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.module.ModulePathResolver;
import mod.fuji.module.initializer.doctor.analyzer.ExceptionAnalyzer;
import mod.fuji.module.mixin.GlobalMixinConfigPlugin;
import org.jetbrains.annotations.NotNull;

public class FujiModuleMixinApplicationExceptionAnalyzer
extends ExceptionAnalyzer {
    @Override
    @NotNull
    protected Pattern makePattern() {
        return Pattern.compile("fuji.mixins.json:(.+?)\\s+from");
    }

    @Override
    public Optional<String> analyze(@NotNull List<Throwable> throwableChain, @NotNull String causeChain) {
        HashSet derivedFQCNs = new HashSet();
        HashSet<CallSite> failedMixinFQCNs = new HashSet<CallSite>();
        Matcher matcher = this.getPattern().matcher(causeChain);
        while (matcher.find()) {
            String mixinName = GlobalMixinConfigPlugin.getMixinRootPackage() + "." + matcher.group(1);
            failedMixinFQCNs.add((CallSite)((Object)mixinName));
        }
        derivedFQCNs.addAll(failedMixinFQCNs);
        failedMixinFQCNs.forEach(mixinFQCN -> ReflectionUtil.CompileTimeGraph.getEventGraph().resolveConsumers((String)mixinFQCN).forEach(it -> derivedFQCNs.add(it.getDeclaringClassName())));
        StringBuilder diagnosisBuilder = new StringBuilder();
        derivedFQCNs.stream().map(ModulePathResolver::computeModulePathString).forEach(modulePathString -> diagnosisBuilder.append("- [Solution] Failed to initialize the '%s' module from 'fuji' mod, please try to disable it in 'config/fuji/config.json' and re-start the server..".formatted(modulePathString)).append(System.lineSeparator()));
        return Optional.of(diagnosisBuilder.toString());
    }
}

