/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public class InventoryHelper {
    private static final List<class_1304> PLAYER_ARMOR_SLOTS = List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);

    public static class_2371<class_1799> getMainStacks(@NotNull class_1657 player) {
        return player.method_31548().field_7547;
    }

    public static class_2371<class_1799> getOffhandStack(@NotNull class_1657 player) {
        class_2371 itemStacks = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1304 offhand = class_1304.field_6171;
        itemStacks.set(0, (Object)player.method_6118(offhand));
        return itemStacks;
    }

    public static class_2371<class_1799> getArmorStacks(@NotNull class_1657 player) {
        class_2371 itemStacks = class_2371.method_10213((int)PLAYER_ARMOR_SLOTS.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < PLAYER_ARMOR_SLOTS.size(); ++i) {
            class_1304 equipmentSlot = PLAYER_ARMOR_SLOTS.get(i);
            itemStacks.set(i, (Object)player.method_6118(equipmentSlot));
        }
        return itemStacks;
    }

    public static Set<class_1799> getInventoryStacks(@NotNull class_1657 player) {
        class_2371<class_1799> mainStacks = InventoryHelper.getMainStacks(player);
        class_2371<class_1799> offhandStacks = InventoryHelper.getOffhandStack(player);
        class_2371<class_1799> armorStacks = InventoryHelper.getArmorStacks(player);
        HashSet<class_1799> stacks = new HashSet<class_1799>();
        stacks.addAll((Collection<class_1799>)mainStacks);
        stacks.addAll((Collection<class_1799>)offhandStacks);
        stacks.addAll((Collection<class_1799>)armorStacks);
        return stacks;
    }

    public static void setArmorStacks(@NotNull class_1657 player, @NotNull List<class_1799> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            player.method_31548().field_7548.set(3 - i, (Object)stacks.get(i));
        }
    }

    public static void setOffhandStacks(@NotNull class_1657 player, @NotNull List<class_1799> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        class_1799 stack = stacks.get(0);
        player.method_31548().field_7544.set(0, (Object)stack);
    }

    public static List<class_2371<class_1799>> getCombinedInventory(@NotNull class_1657 player) {
        return ImmutableList.of(InventoryHelper.getMainStacks(player), InventoryHelper.getArmorStacks(player), InventoryHelper.getOffhandStack(player));
    }

    public static class_2371<class_1799> getHeldStacks(@NotNull class_1277 inventory) {
        return inventory.method_54454();
    }
}

