/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.afk;

import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.afk.config.model.AfkConfigModel;
import mod.fuji.module.initializer.afk.service.AfkService;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751826238005L, value="This module provides:\n1. Afk Detection: When a player remains `idle` beyond a specified threshold, they are marked as being in `the AFK state`.\n2. Afk Event: Execute configured commands when a player `enters` or `leaves` the afk state.\n3. Afk Name Customization: Allows customization of the `display name` of AFK players.\n")
@ColorBox(id=1751870451351L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n\nFor each player, define a `number` to track `the last action time`.\nActions can be: `mine a block`, `movement`, `issue a command` ...\nWhen action received, update the number.\nDefine a `job` using cron, to be triggered periodically.\nThe job will check and compare 2 consecutive value of the `number`.\nIf number is identical, then the player is considered as in `afk`.\n")
public class AfkInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<AfkConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", AfkConfigModel.class);

    @CommandNode(value="afk")
    @Document(id=1751826266551L, value="Enter afk state.")
    private static int $afk(@CommandSource @CommandTarget class_3222 player) {
        if (!AfkService.canEnterAfk(player)) {
            TextHelper.sendTextByKey(player, "afk.on.failed", new Object[0]);
            return 0;
        }
        AfkService.changeAfk(player, true);
        TextHelper.sendTextByKey(player, "afk.on", new Object[0]);
        return 1;
    }

    @Document(id=1751826271499L, value="Test if a player is in afk state.")
    @CommandNode(value="is-afk?")
    @CommandRequirement(level=4)
    private static int $isAfk(@CommandSource class_2168 source, class_3222 player) {
        boolean value = AfkService.isAfk(player);
        return CommandHelper.Return.returnBoolean(source, value);
    }
}

