/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_toolbox.tppos;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.command.argument.wrapper.impl.BiomeId;
import mod.fuji.core.command.argument.wrapper.impl.Dimension;
import mod.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import mod.fuji.core.command.argument.wrapper.impl.PlayerCollection;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.service.random_teleport.RandomTeleporter;
import mod.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Document(id=1751825242047L, value="Provides `/tppos` command.\nA `unified` and `powerful` teleport command.\n\nFor example:\n- `/tppos --z 64 --x 32 --y 128` to teleport to `a specified position`\n- `/tppos --others Steve` to specify the `target player`.\n- `/tppos offline Alex` to teleport to the `offline position of Alex`.\n- `/tppos --dimension` to specify the `target dimension`, and start `a random tp`.\n- `/tppos --minRange 1000 --maxRange 2000` to specify the setup for `a random tp`.\n- `/tppos here @a` to teleport `all online players` to `you`.\n- `/tppos --biome minecraft:mushroom_fields`\n")
@TestCase(action="Issue the command `/tppos --z 64 --x 32 --y 128`", targets={"The command context should be passed after the command redirection."})
public class TpposInitializer
extends ModuleInitializer {
    @Document(id=1751825250986L, value="The unified teleport command.")
    @CommandNode(value="tppos")
    @CommandRequirement(level=4)
    private static int $tppos(@CommandSource @CommandTarget class_3222 player, @Document(id=1751825286136L, value="the target dimension") Optional<Dimension> dimension, @Document(id=1751825291728L, value="the target x for fixed-tp") Optional<Double> x, @Document(id=1751825295183L, value="the target y for fixed-tp") Optional<Double> y, @Document(id=1751825298686L, value="the target z for fixed-tp") Optional<Double> z, @Document(id=1751825302162L, value="the target yaw for fixed-tp") Optional<Float> yaw, @Document(id=1751825308511L, value="the target pitch for fixed-tp") Optional<Float> pitch, @Document(id=1751825312187L, value="center x for rtp") Optional<Integer> centerX, @Document(id=1751825318126L, value="center z for rtp") Optional<Integer> centerZ, @Document(id=1751825322575L, value="is the shape of rtp circle or square") Optional<Boolean> circle, @Document(id=1751825327440L, value="min radius for rtp") Optional<Integer> minRange, @Document(id=1751825331634L, value="max radius for rtp") Optional<Integer> maxRange, @Document(id=1751825335795L, value="min y for rtp") Optional<Integer> minY, @Document(id=1751825340303L, value="max y for rtp") Optional<Integer> maxY, @Document(id=1751825344683L, value="max try times for rtp") Optional<Integer> maxTryTimes, Optional<Integer> asyncChunkLoadingTimeoutTicks, Optional<Integer> chunkInhabitedTimeLowerThanTicks, Optional<BiomeId> biome) {
        class_3218 world;
        class_3218 class_32182 = world = dimension.isPresent() ? (class_3218)dimension.get().getValue() : EntityHelper.getServerWorld((class_1297)player);
        if (x.isPresent() || y.isPresent() || z.isPresent()) {
            double $x = x.orElse(player.method_23317());
            double $y = y.orElse(player.method_23318());
            double $z = z.orElse(player.method_23321());
            float $yaw = yaw.orElse(Float.valueOf(player.method_36454())).floatValue();
            float $pitch = pitch.orElse(Float.valueOf(player.method_36455())).floatValue();
            GlobalPos globalPos = new GlobalPos((class_1937)world, $x, $y, $z, $yaw, $pitch);
            globalPos.teleport(player);
            return 1;
        }
        int $centerX = centerX.orElse((int)world.method_8621().method_11964());
        int $centerZ = centerZ.orElse((int)world.method_8621().method_11980());
        boolean $circle = circle.orElse(false);
        int $minRange = minRange.orElse(0);
        int $maxRange = maxRange.orElse((int)world.method_8621().method_11965() / 2);
        int $minY = minY.orElse(world.method_31607());
        int $maxY = maxY.orElse(WorldHelper.getTopY((class_1937)world));
        int $maxTryTimes = maxTryTimes.orElse(8);
        String worldId = RegistryHelper.getIdAsString((class_1937)world);
        int $asyncChunkLoadingTimeoutTicks = asyncChunkLoadingTimeoutTicks.orElse(200);
        int $chunkInhabitedTimeLowerThanTicks = chunkInhabitedTimeLowerThanTicks.orElse(Integer.MAX_VALUE);
        RandomTeleportSettings.Biomes biomes = biome.map($biome -> {
            RandomTeleportSettings.Biomes result = new RandomTeleportSettings.Biomes();
            result.getSkip().clear();
            result.getOnlyAcceptBiomesMode().setEnable(true);
            class_2960 biomeId = (class_2960)$biome.getValue();
            result.getOnlyAcceptBiomesMode().setAccept(Set.of(RegistryHelper.getIdAsString(biomeId)));
            return result;
        }).orElseGet(RandomTeleportSettings.Biomes::new);
        RandomTeleportSettings randomTeleportSettings = new RandomTeleportSettings(true, worldId, $centerX, $centerZ, $circle, $minRange, $maxRange, $minY, $maxY, $maxTryTimes, $asyncChunkLoadingTimeoutTicks, $chunkInhabitedTimeLowerThanTicks, biomes, new RandomTeleportSettings.Blocks());
        RandomTeleporter.request(player, randomTeleportSettings, null);
        return 1;
    }

    @Document(id=1751825355777L, value="Teleport to the offline position of a player.")
    @CommandNode(value="tppos offline")
    @CommandRequirement(level=4)
    @TestCase(action="Teleport to an offline player's location using `/tppos offline`", targets={"We should be able to make the offline player instance.", "The saved dimension of the offline player should not be reset to minecraft:overworld"})
    private static int $tppos(@CommandSource class_3222 source, OfflinePlayerName player) {
        class_3222 dummyPlayer = PlayerHelper.Loader.loadDummyPlayer((String)player.getValue());
        GlobalPos.of(dummyPlayer).teleport(source);
        return 1;
    }

    @Document(id=1751825360963L, value="Teleport `others` to `you`.\n\nFor example:\n1. `/tppos here Steve` to teleport `Steve` to `you`.\n2. `/tppos here @a` to teleport `all online players` to `you`.\n")
    @CommandNode(value="tppos here")
    @CommandRequirement(level=4)
    private static int $tppos(@CommandSource class_3222 source, PlayerCollection targets) {
        Collection $targets = (Collection)targets.getValue();
        GlobalPos globalPos = GlobalPos.of(source);
        $targets.forEach(globalPos::teleport);
        return 1;
    }
}

