/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.builder.component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.module.initializer.document.builder.component.DocumentBuilder;
import mod.fuji.module.initializer.document.builder.context.DocumentBuilderContext;
import mod.fuji.module.initializer.document.config.adapter.DocumentedTypeAdapterFactory;
import mod.fuji.module.initializer.document.formatter.MarkdownDocumentFormatter;
import org.jetbrains.annotations.NotNull;

public class ModuleConfigurationsDocumentBuilder
extends DocumentBuilder {
    private static final AtomicReference<Object> documentGson = new AtomicReference();

    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<BaseConfigurationHandler> moduleConfigurationHandlers = BaseConfigurationHandler.getObjectConfigurationHandlers().stream().filter(it -> it.getSourceModule().equals(documentBuilderContext.getModulePathString())).toList();
        if (!moduleConfigurationHandlers.isEmpty()) {
            documentBuilderContext.getDocumentBuilder().append("## Configurations").append(System.lineSeparator());
            documentBuilderContext.getDocumentBuilder().append("<Admonition type=\"warning\" icon=\"\" title=\"\">\n**The following JSON content is provided for reference only.**\nIt must NOT be copied directly into the configuration directory, as it does not represent valid JSON syntax.\n</Admonition>\n");
            moduleConfigurationHandlers.forEach(it -> this.build(documentBuilderContext, (BaseConfigurationHandler<?>)it));
        }
    }

    public void build(@NotNull DocumentBuilderContext documentBuilderContext, @NotNull BaseConfigurationHandler<?> baseConfigurationHandler) {
        String configFileName = baseConfigurationHandler.getFilePath().getFileName().toString();
        String configFilePath = baseConfigurationHandler.computeRelativePathBasedOnGameDir();
        documentBuilderContext.getDocumentBuilder().append(":::config").append(System.lineSeparator()).append("- File Name: `%s`".formatted(configFileName)).append(System.lineSeparator());
        Class<?> configModelClass = baseConfigurationHandler.model().getClass();
        DocumentUtil.getClassDocumentString(null, configModelClass).ifPresent(configModelClassDocumentString -> {
            configModelClassDocumentString = MarkdownDocumentFormatter.parseDocumentString(configModelClassDocumentString);
            documentBuilderContext.getDocumentBuilder().append("- Document: %s".formatted(configModelClassDocumentString));
        });
        DocumentedTypeAdapterFactory.FLATTEN_DOCUMENT_STRING_MAP.clear();
        String jsonString = ModuleConfigurationsDocumentBuilder.getDocumentGson().toJson(baseConfigurationHandler.getDefaultModel());
        documentBuilderContext.getDocumentBuilder().append("- File Content: ").append(System.lineSeparator()).append("<details>\n\n<summary>_Click to see the `default` content..._</summary>\n").append(System.lineSeparator()).append("```json showLineNumbers title=\"%s\"".formatted(configFilePath)).append(System.lineSeparator()).append("%s".formatted(jsonString)).append(System.lineSeparator()).append("```").append(System.lineSeparator()).append("</details>").append(System.lineSeparator());
        documentBuilderContext.getDocumentBuilder().append(":::").append(System.lineSeparator());
    }

    @NotNull
    private static Gson makeDocumentGson() {
        GsonBuilder gsonBuilder = GsonMapper.__GetInternalGsonReferenceWithoutTheUseOfWrappedFunctions().newBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DocumentedTypeAdapterFactory());
        return gsonBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Gson getDocumentGson() {
        Object $value = documentGson.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = documentGson;
            synchronized (atomicReference) {
                $value = documentGson.get();
                if ($value == null) {
                    Gson actualValue = ModuleConfigurationsDocumentBuilder.makeDocumentGson();
                    $value = actualValue == null ? documentGson : actualValue;
                    documentGson.set($value);
                }
            }
        }
        return (Gson)($value == documentGson ? null : $value);
    }
}

