/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.economy;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyProvider;
import eu.pb4.common.economy.api.EconomyTransaction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.OfflineGameProfile;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.service.paged_text.PagedMessageText;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.economy.EconomyPlaceholders;
import mod.fuji.module.initializer.economy.command.argument.wrapper.CurrencyId;
import mod.fuji.module.initializer.economy.config.model.EconomyConfigModel;
import mod.fuji.module.initializer.economy.config.model.EconomyDataModel;
import mod.fuji.module.initializer.economy.gui.BalanceTopGui;
import mod.fuji.module.initializer.economy.service.EconomyService;
import mod.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import mod.fuji.module.initializer.economy.structure.GameProfileAndEconomyAccount;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@Document(id=1751826915564L, value="This module enables the `economy gameplay`.\nIt allows defining `custom currency types`.\n\nA `player` can have multiple `accounts`.\nEach `account` holds one type of `currency`.\n")
@ColorBoxes(value={@ColorBox(id=1751870587446L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Make the `Admin Shops` and `Player Shops`.\nYou can use this module with `Universal Shops` mod.\nThis mod provides the `Admin Shops` and `Player Shops`.\nIt brings the similar gameplay into `fabric` like `QuickShop` plugin in `bukkit`.\n"), @ColorBox(id=1751870591800L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `/balance` command for players to use.\nYou can use `command_bundle` module.\nTo create a `/balance` command, to wrap the `/economy account %player:name% fuji:gold` command.\nSo the players can query the balance conveniently.\n\n\u25c9 Query the `balance` of all `currencies` for self.\nIssue: `/economy balance`\n\n\u25c9 Query the `balance` of all `currencies` for a target player.\nIssue: `/economy accounts Steve`\n\n\u25c9 Query the `balance` of the specified `currency` for a target player.\nIssue: `/economy account Steve fuji:gold`\n\n\u25c9 `Give`, `take`, `set` or `clear` the `balance` of specified `currency` for a player.\n1. `/economy give Steve fuji:gold 100`\n2. `/economy take Steve fuji:gold 100`\n3. `/economy set Steve fuji:gold 100`\n4. `/economy clear Steve fuji:gold --confirm true`\n\n\u25c9 Transfer the specified `balance` of specified `currency` from self to another player.\nIssue: `/economy pay Bob fuji:gold 100`\n")})
public class EconomyInitializer
extends ModuleInitializer {
    public static BaseConfigurationHandler<EconomyConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", EconomyConfigModel.class);
    public static BaseConfigurationHandler<EconomyDataModel> data = ObjectConfigurationHandler.ofModule("economy-data.json", EconomyDataModel.class);

    @Document(id=1751826918349L, value="List all installed `economy providers`, and what `economy currencies` they provided.\n")
    @CommandNode(value="economy providers")
    @CommandRequirement(level=4)
    private static int $providers(@CommandSource class_2168 source) {
        Collection<EconomyProvider> providers = EconomyService.getProviders();
        TextHelper.sendMessageByText(source, (class_2561)class_2561.method_43470((String)"There are %d providers installed in this server.".formatted(providers.size())));
        providers.forEach(provider -> {
            MinecraftServer server = ServerHelper.getServer();
            TextHelper.sendTextByKey(source, "line.separator", new Object[0]);
            TextHelper.sendTextByKey(source, "economy.provider.id", provider.id());
            class_2561 providerNameText = TextHelper.getTextByKey(source, "economy.provider.name.display", new Object[0]);
            providerNameText = TextHelper.Replacer.replaceTextWithNamedArgument(providerNameText, "name", matcher -> provider.name());
            TextHelper.sendMessageByText(source, providerNameText);
            TextHelper.sendTextByKey(source, "economy.provider.icon", provider.icon().method_7909());
            Collection currencies = provider.getCurrencies(server);
            currencies.forEach(currency -> {
                TextHelper.sendTextByKey(source, "economy.currency.id", currency.id());
                class_2561 currencyNameText = TextHelper.getTextByKey(source, "economy.currency.name.display", new Object[0]);
                currencyNameText = TextHelper.Replacer.replaceTextWithNamedArgument(currencyNameText, "name", matcher -> currency.name());
                TextHelper.sendMessageByText(source, currencyNameText);
                TextHelper.sendTextByKey(source, "economy.currency.icon", currency.icon().method_7909());
                TextHelper.sendMessageByText(source, TextHelper.TEXT_EMPTY);
            });
        });
        return 1;
    }

    @Document(id=1751826920505L, value="List all `accounts` owned by the `player`.\n")
    @CommandNode(value="economy accounts")
    @CommandRequirement(level=4)
    private static int $accounts(@CommandSource class_2168 source, OfflineGameProfile player) {
        Collection<EconomyAccount> accounts = EconomyService.getUserAccounts((GameProfile)player.getValue());
        accounts.forEach(account -> EconomyInitializer.printEconomyAccountInfo(source, account));
        return 1;
    }

    private static void printEconomyAccountInfo(class_2168 source, EconomyAccount account) {
        class_2561 accountNameText = TextHelper.getTextByKey(source, "economy.account.name.display", new Object[0]);
        accountNameText = TextHelper.Replacer.replaceTextWithNamedArgument(accountNameText, "name", matcher -> account.name());
        class_2561 balanceText = TextHelper.getTextByKey(source, "economy.account.balance.display", new Object[0]);
        balanceText = TextHelper.Replacer.replaceTextWithNamedArgument(balanceText, "balance", matcher -> account.formattedBalance());
        TextHelper.sendMessageByText(source, accountNameText);
        TextHelper.sendMessageByText(source, balanceText);
        TextHelper.sendMessageByText(source, TextHelper.TEXT_EMPTY);
    }

    @Document(id=1751826922680L, value="Get the `player`'s `account` for `currency ID`.\n")
    @CommandNode(value="economy account")
    @CommandRequirement(level=4)
    private static int $account(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(source, (GameProfile)player.getValue(), $currencyId);
        EconomyInitializer.printEconomyAccountInfo(source, economyAccount);
        return 1;
    }

    @Document(id=1751826925194L, value="Query your economy `accounts`.\n")
    @CommandNode(value="economy balance")
    @CommandRequirement(level=4)
    private static int $balance(@CommandSource class_3222 player) {
        OfflineGameProfile offlineGameProfile = new OfflineGameProfile(player.method_7334());
        EconomyInitializer.$accounts(player.method_5671(), offlineGameProfile);
        return 1;
    }

    @Document(id=1751826927389L, value="List the top players of specified currency using GUI.\n")
    @CommandNode(value="economy balance-top gui")
    @CommandRequirement(level=4)
    private static int $balanceTopGui(@CommandSource class_3222 player, CurrencyId currencyId) {
        BalanceTopGui.make(player, (class_2960)currencyId.getValue()).open();
        return 1;
    }

    @Document(id=1753498885843L, value="List the top players of specified currency using message.\n")
    @CommandNode(value="economy balance-top")
    @CommandRequirement(level=4)
    private static int $balanceTop(@CommandSource class_3222 player, CurrencyId currencyId) {
        List<GameProfileAndEconomyAccount> entities = EconomyService.makeBalanceTopEntities(player, (class_2960)currencyId.getValue());
        PagedMessageText pagedMessageText = PagedMessageText.makePagedMessageText(player, entities, EconomyService.getBalanceTopPageSize(), (entity, index, pageBuilder) -> {
            int numbering = index + 1;
            String playerName = AuthlibHelper.getName(entity.getGameProfile());
            String balanceString = TextHelper.Operators.getString(entity.economyAccount.formattedBalance());
            pageBuilder.method_10852(TextHelper.getTextByKey(player, "economy.balance.top.entry", numbering, playerName, balanceString));
        });
        pagedMessageText.sendPage(player, 0);
        return 1;
    }

    @Document(id=1751826931165L, value="Give `amount` to the player's `account` for `specified currency`.")
    @CommandNode(value="economy give")
    @CommandRequirement(level=4)
    private static int $give(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(source, (GameProfile)player.getValue(), $currencyId);
        long deltaValue = (long)(amount * 100.0);
        EconomyTransaction economyTransaction = economyAccount.increaseBalance(deltaValue);
        TextHelper.sendMessageByText(source, economyTransaction.message());
        return 1;
    }

    @Document(id=1751826933066L, value="Take `amount` from the player's `account` for `specified currency`.")
    @CommandNode(value="economy take")
    @CommandRequirement(level=4)
    private static int $take(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(source, (GameProfile)player.getValue(), $currencyId);
        long deltaValue = (long)(amount * 100.0);
        EconomyTransaction economyTransaction = economyAccount.decreaseBalance(deltaValue);
        TextHelper.sendMessageByText(source, economyTransaction.message());
        return 1;
    }

    @Document(id=1751826934778L, value="Pay specified `amount` of `currency` to another player's account.")
    @CommandNode(value="economy pay")
    @CommandRequirement(level=4)
    private static int $pay(@CommandSource class_3222 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        EconomyService.transferCurrency(source, player, (class_2960)currencyId.getValue(), amount);
        return 1;
    }

    @Document(id=1751826937120L, value="Has the specified amount of currency?")
    @CommandNode(value="has-currency?")
    @CommandRequirement(level=4)
    private static int $hasCurrency(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(source, (GameProfile)player.getValue(), $currencyId);
        long finalValue = (long)(amount * 100.0);
        boolean value = economyAccount.balance() >= finalValue;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826939422L, value="Set the `amount` of the player's `account` for `specified currency`.")
    @CommandNode(value="economy set")
    @CommandRequirement(level=4)
    private static int $set(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(source, (GameProfile)player.getValue(), $currencyId);
        long finalValue = (long)(amount * 100.0);
        economyAccount.setBalance(finalValue);
        TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
        return 1;
    }

    @Document(id=1751826942040L, value="Clear the `amount` of the player's `account` for `specified currency`.")
    @CommandNode(value="economy clear")
    @CommandRequirement(level=4)
    private static int $clear(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            EconomyInitializer.$set(source, player, currencyId, 0.0);
            return 1;
        });
    }

    @Override
    protected void registerPlaceholders() {
        EconomyPlaceholders.registerBalancePlaceholder();
    }

    static {
        CustomEconomyProvider.initializeCustomEconomyProvider();
    }
}

