/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.skin;

import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.command.argument.wrapper.impl.GreedyString;
import mod.fuji.core.command.argument.wrapper.impl.Word;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.Cite;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.service.gameprofile_fetcher.MojangSkinProvider;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.skin.command.argument.wrapper.DefaultSkinName;
import mod.fuji.module.initializer.skin.config.model.SkinConfigModel;
import mod.fuji.module.initializer.skin.config.model.SkinDataModel;
import mod.fuji.module.initializer.skin.gui.SkinGui;
import mod.fuji.module.initializer.skin.provider.MineSkinSkinProvider;
import mod.fuji.module.initializer.skin.service.SkinService;
import mod.fuji.module.initializer.skin.structure.SkinVariant;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

@Document(id=1751826807167L, value="This module provides the `skin` management for players.\n")
@ColorBoxes(value={@ColorBox(id=1753325192275L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nThis module provides the `skin` management:\n1. This module will `modify the skin` when the the player `login the server`.\n1.a. If there is existing `skin data` for this `player`, then we use that data.\n1.b. If there is no existing `skin data` for this `player`.\n1.b.i. If the `apply_default_skin_if_no_data` option is `true`, then we use `default skin` defined in the config file.\n1.b.ii. If the `apply_default_skin_if_no_data` option is `false`, then we fetch the skin from `Mojang online server`.\n\n2. A player can use `/skin` command to `change the skin` in-game.\n"), @ColorBox(id=1751979120689L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use the `Mojang skin`.\nIssue: `/skin use-my-mojang-skin` to use your own skin.\nIssue: `/skin use-mojang-skin Alice` to use another player's skin.\n<red>NOTE: This requires fetching the skin from the Mojang server, which may be time-consuming.\n\n\u25c9 Set a skin from custom URL\nIssue: `/skin use-url-skin alex https://s.namemc.com/i/2af8c11db5fe6061.png`\n\n\u25c9 Use a `specified skin name` from the `default skin list` defined in the config file.\nIssue: `/skin use-default-skin reimu-hakurei`\n\n\u25c9 Use a `random` skin from the `default skin list` defined in the config file.\nIssue: `/skin use-random-default-skins`\n")})
@Cite(value={"https://github.com/Suiranoil/SkinRestorer"})
@CommandNode(value="skin")
public class SkinInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SkinConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", SkinConfigModel.class);
    public static final BaseConfigurationHandler<SkinDataModel> data = ObjectConfigurationHandler.ofModule("skin-data.json", SkinDataModel.class);

    @Document(id=1751826809279L, value="Set skin to a random default skin.")
    @CommandNode(value="use-random-default-skins")
    private static int $useRandomDefaultSkins(@CommandSource @CommandTarget class_3222 player) {
        SkinService.changeSkin(player, SkinService::getRandomDefaultSkin);
        return 1;
    }

    @Document(id=1753333877248L, value="Use the `default skin` with specified `skin name`.")
    @CommandNode(value="use-default-skin")
    private static int $useDefaultSkin(@CommandSource @CommandTarget class_3222 player, DefaultSkinName defaultSkinName) {
        String $defaultSkinName = (String)defaultSkinName.getValue();
        return SkinService.findSkinDescriptor($defaultSkinName).map(skinDescriptor -> {
            SkinService.changeSkin(player, () -> skinDescriptor.getSkinProperty().toVanillaType());
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(player, "skin.default_skin.unknown", $defaultSkinName);
            return 0;
        });
    }

    @Document(id=1753336550266L, value="Open the `skin` GUI.\n")
    @CommandNode(value="gui")
    private static int $gui(@CommandSource class_3222 player) {
        SkinGui.makeInstance(player).open();
        return 1;
    }

    @Document(id=1753337059662L, value="Alias to `/skin gui` command.\n")
    @CommandNode
    private static int $skin(@CommandSource class_3222 player) {
        return SkinInitializer.$gui(player);
    }

    @Document(id=1751826814466L, value="Set skin to an online skin of the same name.")
    @CommandNode(value="use-my-mojang-skin")
    private static int $useMyMojangSkin(@CommandSource @CommandTarget class_3222 player) {
        String onlinePlayerName = PlayerHelper.getPlayerName((class_1657)player);
        SkinService.changeSkin(player, () -> MojangSkinProvider.fetchSkin(onlinePlayerName).orElse(null));
        return 1;
    }

    @Document(id=1753250702541L, value="Set skin to an online skin of the specified name.")
    @CommandNode(value="use-mojang-skin")
    private static int $useMojangSkin(@CommandSource @CommandTarget class_3222 player, Word skinName) {
        SkinService.changeSkin(player, () -> MojangSkinProvider.fetchSkin((String)skinName.getValue()).orElse(null));
        return 1;
    }

    @Document(id=1751826819277L, value="Set skin to a custom url in Steve model.")
    @CommandNode(value="use-url-skin steve")
    private static int $useUrlSkinSteveModel(@CommandSource @CommandTarget class_3222 player, GreedyString url) {
        String $url = (String)url.getValue();
        SkinService.changeSkin(player, () -> MineSkinSkinProvider.fetchSkin($url, SkinVariant.CLASSIC).orElse(null));
        return 1;
    }

    @Document(id=1751826827369L, value="Set skin to a custom url in Alex model.")
    @CommandNode(value="use-url-skin alex")
    private static int $useUrlSkinAlexModel(@CommandSource @CommandTarget class_3222 player, GreedyString url) {
        String $url = (String)url.getValue();
        SkinService.changeSkin(player, () -> MineSkinSkinProvider.fetchSkin($url, SkinVariant.SLIM).orElse(null));
        return 1;
    }
}

