/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager.structure;

import com.google.gson.annotations.SerializedName;
import java.util.Optional;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.ChunkGeneratorType;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.WorldPresetType;
import net.minecraft.class_1267;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

@Document(id=1752170874671L, value="A `dimension descriptor` is used to describe a `runtime dimension`.\nIt contains the important info about a `dimension`, like the `dimension id`, `dimension type` and `seed`...\n")
public class RuntimeDimensionDescriptor {
    @Document(id=1752170969085L, value="Should we `load` this `dimension` on server startup?\n")
    @SerializedName(value="auto_load_on_server_startup", alternate={"enable"})
    public boolean auto_load_on_server_startup = true;
    @Document(id=1752170986625L, value="The `identifier` of this `dimension`.\n")
    public String dimension = null;
    @Document(id=1752738994765L, value="The `world preset type` used by this `dimension`.\n\nIf `world preset type` is specified, then `dimension type`, `chunk generator type` and `chunk generator parameters` are ignored.\n")
    @Nullable
    public WorldPresetType worldPresetType = null;
    @Document(id=1752171006784L, value="The `dimension type` of this `dimension`.\n\nFor `FlatChunkGenerator`:\n1. The `dimension type` defines the `dimension environment`.\n\nFor `NoiseChunkGenerator`:\n1. The `dimension type` defines the `dimension environment`.\n2. The `dimension type` defines the `chunk generator`.\n\n<green>NOTE: The `dimension environment` specifies things like: `bed explosion?`, `infinite burning?`, `has skylight?`...\n")
    @SerializedName(value="dimension_type", alternate={"dimensionType"})
    public String dimension_type = null;
    @Document(id=1752729741419L, value="The `chunk generator` of this `dimension`.\nNote that in vanilla Minecraft, the `chunk generator` of `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end` are all `NoiseChunkGenerator`.\n\n<green>For a non-vanilla chunk generator provided by mods, you can just specify this value to `NOISE`.\n<green>If this value is specified to `NOISE`, then we will just use whatever the chunk generator that mod is using.\n")
    public ChunkGeneratorType chunkGeneratorType = ChunkGeneratorType.NOISE;
    @Document(id=1752734540525L, value="The `parameters` used by the `chunk generator`.\n\nFor `flat chunk generator`, you can specify the `preset string` as the `parameters`.\n")
    public String chunkGeneratorParameters = "";
    @Document(id=1752246679197L, value="The `seed` used for the `chunk generator` of this dimension.\n")
    public long seed;
    public class_1267 difficulty = class_1267.field_5802;
    @Document(id=1752246657296L, value="Should we tick the time of this `dimension`? (Do the day night cycle?)\n")
    public boolean shouldTickTime;
    @Document(id=1752286206946L, value="The equivalent to `DayTime` in `level.dat`.\n")
    public long timeOfDay = 6000L;
    public Weather weather = new Weather();

    public boolean isDimensionLoaded() {
        return WorldHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.getIdAsString((class_1937)it).equals(this.dimension));
    }

    public boolean isDebugWorld() {
        return WorldPresetType.DEBUG_ALL_BLOCK_STATES == this.worldPresetType;
    }

    public Optional<class_3218> getLoadedWorld() {
        return WorldHelper.getWorld(this.dimension);
    }

    @Generated
    public boolean isAuto_load_on_server_startup() {
        return this.auto_load_on_server_startup;
    }

    @Generated
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @Generated
    public WorldPresetType getWorldPresetType() {
        return this.worldPresetType;
    }

    @Generated
    public String getDimension_type() {
        return this.dimension_type;
    }

    @Generated
    public ChunkGeneratorType getChunkGeneratorType() {
        return this.chunkGeneratorType;
    }

    @Generated
    public String getChunkGeneratorParameters() {
        return this.chunkGeneratorParameters;
    }

    @Generated
    public long getSeed() {
        return this.seed;
    }

    @Generated
    public class_1267 getDifficulty() {
        return this.difficulty;
    }

    @Generated
    public boolean isShouldTickTime() {
        return this.shouldTickTime;
    }

    @Generated
    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    @Generated
    public Weather getWeather() {
        return this.weather;
    }

    @Generated
    public RuntimeDimensionDescriptor setAuto_load_on_server_startup(boolean auto_load_on_server_startup) {
        this.auto_load_on_server_startup = auto_load_on_server_startup;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setWorldPresetType(@Nullable WorldPresetType worldPresetType) {
        this.worldPresetType = worldPresetType;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setDimension_type(String dimension_type) {
        this.dimension_type = dimension_type;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setChunkGeneratorType(ChunkGeneratorType chunkGeneratorType) {
        this.chunkGeneratorType = chunkGeneratorType;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setChunkGeneratorParameters(String chunkGeneratorParameters) {
        this.chunkGeneratorParameters = chunkGeneratorParameters;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setSeed(long seed) {
        this.seed = seed;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setDifficulty(class_1267 difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setShouldTickTime(boolean shouldTickTime) {
        this.shouldTickTime = shouldTickTime;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setTimeOfDay(long timeOfDay) {
        this.timeOfDay = timeOfDay;
        return this;
    }

    @Generated
    public RuntimeDimensionDescriptor setWeather(Weather weather) {
        this.weather = weather;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeDimensionDescriptor)) {
            return false;
        }
        RuntimeDimensionDescriptor other = (RuntimeDimensionDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuto_load_on_server_startup() != other.isAuto_load_on_server_startup()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isShouldTickTime() != other.isShouldTickTime()) {
            return false;
        }
        if (this.getTimeOfDay() != other.getTimeOfDay()) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        WorldPresetType this$worldPresetType = this.getWorldPresetType();
        WorldPresetType other$worldPresetType = other.getWorldPresetType();
        if (this$worldPresetType == null ? other$worldPresetType != null : !((Object)((Object)this$worldPresetType)).equals((Object)other$worldPresetType)) {
            return false;
        }
        String this$dimension_type = this.getDimension_type();
        String other$dimension_type = other.getDimension_type();
        if (this$dimension_type == null ? other$dimension_type != null : !this$dimension_type.equals(other$dimension_type)) {
            return false;
        }
        ChunkGeneratorType this$chunkGeneratorType = this.getChunkGeneratorType();
        ChunkGeneratorType other$chunkGeneratorType = other.getChunkGeneratorType();
        if (this$chunkGeneratorType == null ? other$chunkGeneratorType != null : !((Object)((Object)this$chunkGeneratorType)).equals((Object)other$chunkGeneratorType)) {
            return false;
        }
        String this$chunkGeneratorParameters = this.getChunkGeneratorParameters();
        String other$chunkGeneratorParameters = other.getChunkGeneratorParameters();
        if (this$chunkGeneratorParameters == null ? other$chunkGeneratorParameters != null : !this$chunkGeneratorParameters.equals(other$chunkGeneratorParameters)) {
            return false;
        }
        class_1267 this$difficulty = this.getDifficulty();
        class_1267 other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty)) {
            return false;
        }
        Weather this$weather = this.getWeather();
        Weather other$weather = other.getWeather();
        return !(this$weather == null ? other$weather != null : !this$weather.equals(other$weather));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuntimeDimensionDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuto_load_on_server_startup() ? 79 : 97);
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isShouldTickTime() ? 79 : 97);
        long $timeOfDay = this.getTimeOfDay();
        result = result * 59 + (int)($timeOfDay >>> 32 ^ $timeOfDay);
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        WorldPresetType $worldPresetType = this.getWorldPresetType();
        result = result * 59 + ($worldPresetType == null ? 43 : ((Object)((Object)$worldPresetType)).hashCode());
        String $dimension_type = this.getDimension_type();
        result = result * 59 + ($dimension_type == null ? 43 : $dimension_type.hashCode());
        ChunkGeneratorType $chunkGeneratorType = this.getChunkGeneratorType();
        result = result * 59 + ($chunkGeneratorType == null ? 43 : ((Object)((Object)$chunkGeneratorType)).hashCode());
        String $chunkGeneratorParameters = this.getChunkGeneratorParameters();
        result = result * 59 + ($chunkGeneratorParameters == null ? 43 : $chunkGeneratorParameters.hashCode());
        class_1267 $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        Weather $weather = this.getWeather();
        result = result * 59 + ($weather == null ? 43 : $weather.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RuntimeDimensionDescriptor(auto_load_on_server_startup=" + this.isAuto_load_on_server_startup() + ", dimension=" + this.getDimension() + ", worldPresetType=" + String.valueOf((Object)this.getWorldPresetType()) + ", dimension_type=" + this.getDimension_type() + ", chunkGeneratorType=" + String.valueOf((Object)this.getChunkGeneratorType()) + ", chunkGeneratorParameters=" + this.getChunkGeneratorParameters() + ", seed=" + this.getSeed() + ", difficulty=" + String.valueOf(this.getDifficulty()) + ", shouldTickTime=" + this.isShouldTickTime() + ", timeOfDay=" + this.getTimeOfDay() + ", weather=" + String.valueOf(this.getWeather()) + ")";
    }

    @Generated
    public RuntimeDimensionDescriptor() {
    }

    public static class Weather {
        public int sunnyTime;
        public boolean isRaining;
        public int rainTime;
        public boolean isThundering;
        public int thunderTime;
    }
}

