/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.warning.structure;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Warning {
    private long createdTimestamp;
    @Nullable
    private Long expirationTimestamp;
    @SerializedName(value="creator_name", alternate={"createdByPlayer", "creatorName"})
    private String creatorName;
    private String description;

    public static Warning make(@NotNull String creatorName, @NotNull String description, @Nullable Long expirationTimestamp) {
        Warning entity = new Warning();
        entity.createdTimestamp = System.currentTimeMillis();
        entity.creatorName = creatorName;
        entity.description = description;
        entity.expirationTimestamp = expirationTimestamp;
        return entity;
    }

    @NotNull
    public List<class_2561> asLore(Object audience) {
        return List.of(TextHelper.getTextByKey(audience, "entity.active", this.isActive()), TextHelper.getTextByKey(audience, "entity.created_by_player", this.creatorName), TextHelper.getTextByKey(audience, "entity.created_timestamp", ChronosUtil.Formatter.formatDate(this.createdTimestamp)), TextHelper.getTextByKey(audience, "entity.expiration_timestamp", ChronosUtil.Formatter.formatDate(this.expirationTimestamp)), TextHelper.getTextByKey(audience, "entity.description", this.description));
    }

    public boolean isTemporalWarning() {
        return !this.isPermanentWarning();
    }

    public boolean isPermanentWarning() {
        return this.getExpirationTimestamp() == null;
    }

    public boolean isActive() {
        if (this.getExpirationTimestamp() == null) {
            return true;
        }
        return System.currentTimeMillis() < this.getExpirationTimestamp();
    }

    @NotNull
    public class_1792 asItem() {
        return GuiHelper.Material.fromBooleanValue(this.isActive());
    }

    @Generated
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Nullable
    @Generated
    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    @Generated
    public String getCreatorName() {
        return this.creatorName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Warning setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
        return this;
    }

    @Generated
    public Warning setExpirationTimestamp(@Nullable Long expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
        return this;
    }

    @Generated
    public Warning setCreatorName(String creatorName) {
        this.creatorName = creatorName;
        return this;
    }

    @Generated
    public Warning setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Warning)) {
            return false;
        }
        Warning other = (Warning)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreatedTimestamp() != other.getCreatedTimestamp()) {
            return false;
        }
        Long this$expirationTimestamp = this.getExpirationTimestamp();
        Long other$expirationTimestamp = other.getExpirationTimestamp();
        if (this$expirationTimestamp == null ? other$expirationTimestamp != null : !((Object)this$expirationTimestamp).equals(other$expirationTimestamp)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Warning;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTimestamp = this.getCreatedTimestamp();
        result = result * 59 + (int)($createdTimestamp >>> 32 ^ $createdTimestamp);
        Long $expirationTimestamp = this.getExpirationTimestamp();
        result = result * 59 + ($expirationTimestamp == null ? 43 : ((Object)$expirationTimestamp).hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Warning(createdTimestamp=" + this.getCreatedTimestamp() + ", expirationTimestamp=" + this.getExpirationTimestamp() + ", creatorName=" + this.getCreatorName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public Warning() {
    }
}

