/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.config.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.inspector.FailedToInspectException;
import mod.fuji.core.document.inspector.JavaObjectInspector;
import mod.fuji.module.initializer.document.config.writter.DocumentJsonWriter;

public class DocumentedTypeAdapterFactory
implements TypeAdapterFactory {
    public static final Map<String, String> FLATTEN_DOCUMENT_STRING_MAP = new HashMap<String, String>();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(this){

            public void write(JsonWriter out, T value) throws IOException {
                if (value != null) {
                    try {
                        JavaObjectInspector.ofRoot(value).flatten().forEach(it -> DocumentUtil.putDocumentStringMap(FLATTEN_DOCUMENT_STRING_MAP, it.getObjectType()));
                    }
                    catch (FailedToInspectException failedToInspectException) {
                        // empty catch block
                    }
                }
                if (!(out instanceof DocumentJsonWriter)) {
                    out = new DocumentJsonWriter(out);
                }
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
    }
}

