/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.rank.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.module.initializer.rank.command.argument.wrapper.PreviousAvailableRankNode;
import mod.fuji.module.initializer.rank.service.RankService;
import mod.fuji.module.initializer.rank.structure.RankNode;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PreviousAvailableRankNodesArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String rankId = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Optional<RankNode> previousRankNode = RankService.getPreviousAvailableRankNodes(player).stream().filter(it -> it.getId().equals(rankId)).findFirst();
        return previousRankNode.map(PreviousAvailableRankNode::new).orElseThrow(() -> {
            TextHelper.sendTextByKey(context.getSource(), "rank.unavailable_rank_node", rankId);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(PreviousAvailableRankNode.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("previous-available-rank-nodes");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable((context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return List.of();
            }
            return RankService.getPreviousAvailableRankNodes(player).stream().map(RankNode::getId).toList();
        }));
    }
}

