/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.Configs;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.inspector.FailedToInspectException;
import mod.fuji.core.document.inspector.JavaObjectInspector;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.fuji.gui.JavaObjectInspectionGui;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TestCase(action="Inspect the configurations of `command_menu` module.", targets={"It should be able to inspect complex data structures."})
public class ConfigurationsInspectionGui
extends PagedGui<BaseConfigurationHandler<?>> {
    public ConfigurationsInspectionGui(@Nullable SimpleGui parent, class_3222 player, @NotNull List<BaseConfigurationHandler<?>> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.configuration.gui.title", new Object[0]), entities, pageIndex);
    }

    public static ConfigurationsInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<BaseConfigurationHandler<?>> entities = BaseConfigurationHandler.getObjectConfigurationHandlers();
        return new ConfigurationsInspectionGui(parent, player, entities, 0);
    }

    @Override
    @NotNull
    protected PagedGui<BaseConfigurationHandler<?>> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<BaseConfigurationHandler<?>> entities, int pageIndex) {
        return new ConfigurationsInspectionGui(parent, player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull BaseConfigurationHandler<?> entity) {
        Class<?> configHandlerClass = entity.getClass();
        String configHandlerClassName = ReflectionUtil.getSimpleClassName(configHandlerClass);
        String configRelativePath = entity.computeRelativePathBasedOnGameDir();
        String fromModule = entity.getSourceModule();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.addAll(List.of(TextHelper.getTextByKey(this.getPlayer(), "from_module", fromModule), TextHelper.getTextByKey(this.getPlayer(), "fuji.inspect.configuration.class", configHandlerClassName), TextHelper.getTextByKey(this.getPlayer(), "fuji.inspect.configuration.path", configRelativePath), TextHelper.getTextByKey(this.getPlayer(), "prompt.click.see_inside", new Object[0])));
        Class<?> configModelClass = entity.model().getClass();
        DocumentUtil.getClassDocumentString(this.getPlayer(), configModelClass).ifPresent(configModelClassDocumentString -> {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.addAll(TextHelper.getDocumentTextList(this.getPlayer(), configModelClassDocumentString));
        });
        SimpleGui trueParentGui = this.getParent() != null ? this.getParent() : this.getBackendGui();
        GuiElementBuilder guiElementBuilder = (GuiElementBuilder)new GuiElementBuilder().setItem(ConfigurationsInspectionGui.toItem(entity)).setName((class_2561)class_2561.method_43470((String)configRelativePath)).setLore(lore).setCallback(() -> this.openRootJavaObjectInspectorGui(trueParentGui, entity, configRelativePath));
        return guiElementBuilder.build();
    }

    private void openRootJavaObjectInspectorGui(@Nullable SimpleGui parent, @NotNull BaseConfigurationHandler<?> entity, @NotNull String fileRelativePath) {
        try {
            JavaObjectInspector rootInspector = JavaObjectInspector.ofRoot(entity.model());
            new JavaObjectInspectionGui(parent, this.getPlayer(), rootInspector.getChildInspectingObjects(), 0, fileRelativePath, rootInspector).open();
        }
        catch (FailedToInspectException e) {
            LogUtil.error("Failed to open the inspector GUI: target object = {}, file path = {}", entity, fileRelativePath, e);
        }
    }

    @NotNull
    private static class_1792 toItem(@NotNull BaseConfigurationHandler<?> entity) {
        if (entity == Configs.MAIN_CONTROL_CONFIG) {
            return class_1802.field_8466;
        }
        return class_1802.field_8247;
    }
}

