/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.document.gui;

import com.mojang.brigadier.context.CommandContext;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.descriptor.CommandDescriptor;
import mod.fuji.core.command.structure.CommandRequirementDescriptor;
import mod.fuji.core.gui.component.gui.PagedGui;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandsInspectionGui
extends PagedGui<CommandDescriptor> {
    public CommandsInspectionGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<CommandDescriptor> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.fuji_commands.gui.title", new Object[0]), entities, pageIndex);
    }

    public static CommandsInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<CommandDescriptor> entities = CommandDescriptor.getCommandDescriptors();
        return new CommandsInspectionGui(parent, player, entities, 0);
    }

    public static int inspectCommandDescriptors(CommandContext<class_2168> ctx, Predicate<CommandDescriptor> filter) {
        Stream<CommandDescriptor> commandDescriptorStream = CommandDescriptor.REGISTERED_COMMAND_DESCRIPTORS.stream().filter(filter);
        class_2168 source = (class_2168)ctx.getSource();
        return Optional.ofNullable(source.method_44023()).map(player -> {
            new CommandsInspectionGui(null, (class_3222)player, commandDescriptorStream.toList(), 0).open();
            return 1;
        }).orElseGet(() -> {
            commandDescriptorStream.forEach(it -> {
                String string = it.getFlatCommandPath().toString();
                TextHelper.sendMessageByText(source, (class_2561)class_2561.method_43470((String)string));
            });
            return 1;
        });
    }

    @Override
    protected PagedGui<CommandDescriptor> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<CommandDescriptor> entities, int pageIndex) {
        return new CommandsInspectionGui(parent, player, entities, pageIndex);
    }

    @NotNull
    private List<class_2561> asLore(@NotNull CommandDescriptor entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        if (entity.document.isPresent()) {
            List<class_2561> methodDocumentTextList = TextHelper.getDocumentTextList(this.getPlayer(), entity.document.get());
            lore.addAll(methodDocumentTextList);
        }
        List<class_2561> parameterDocumentTextList = entity.commandArguments.stream().filter(it -> it.getDocument() != null).map(it -> {
            class_2561 documentText = TextHelper.getDocumentText(this.getPlayer(), "\u25c9 %s: %s".formatted(it.getArgumentName(), it.getDocument()));
            return documentText;
        }).toList();
        lore.addAll(parameterDocumentTextList);
        return lore;
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull CommandDescriptor entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        CommandRequirementDescriptor commandRequirement = CommandDescriptor.CommandRequirement.computeCommandRequirement(entity);
        lore.addAll(List.of(TextHelper.getTextByKey(this.getPlayer(), "from_module", entity.getSourceModule()), TextHelper.getTextByKey(this.getPlayer(), "command.source.can_be_executed_by_console", entity.canBeExecutedByConsole()), TextHelper.getTextByKey(this.getPlayer(), "command.descriptor.type", entity.getClass().getSimpleName()), TextHelper.getTextByKey(this.getPlayer(), "command.requirement.level_permission", commandRequirement.getLevel()), TextHelper.getTextByKey(this.getPlayer(), "command.requirement.string_permission", commandRequirement.getString())));
        List<class_2561> documents = this.asLore(entity);
        if (!documents.isEmpty()) {
            documents.add(0, (class_2561)class_2561.method_43473());
            lore.addAll(documents);
        }
        return new GuiElementBuilder().setName((class_2561)class_2561.method_43470((String)entity.getUserFriendlyCommandSyntax())).setItem(class_1802.field_8468).setLore(lore).build();
    }
}

