/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.job.abst;

import java.util.function.Supplier;
import lombok.Generated;
import mod.fuji.core.job.abst.BaseJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public abstract class FixedIntervalJob
extends BaseJob {
    public static final int REPEAT_INDEFINITELY = -1;
    private Supplier<Integer> intervalInMillSecondsSupplier;
    private int repeatCount;

    public FixedIntervalJob(@Nullable String jobGroup, @Nullable String jobName, @Nullable JobDataMap jobDataMap, Supplier<Integer> intervalInMillSecondsSupplier, int repeatCount, boolean staticJob) {
        super(jobGroup, jobName, jobDataMap, staticJob);
        this.intervalInMillSecondsSupplier = intervalInMillSecondsSupplier;
        this.repeatCount = repeatCount;
    }

    @Override
    @NotNull
    public Trigger makeTrigger() {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.getTriggerKey());
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)this.intervalInMillSecondsSupplier.get().intValue());
        if (this.repeatCount == -1) {
            scheduleBuilder.repeatForever();
        } else {
            scheduleBuilder.withRepeatCount(this.repeatCount - 1);
        }
        return triggerBuilder.withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }

    @Generated
    public FixedIntervalJob() {
    }
}

