/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.leaderboard.structure;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.leaderboard.structure.LeaderBoardCache;
import mod.fuji.module.initializer.leaderboard.structure.LeaderBoardTimeWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeaderBoardSnapshot {
    @Document(id=1753493148676L, value="The `time window` of this `snapshot`.\n")
    private LeaderBoardTimeWindow timeWindow;
    @Document(id=1753493186554L, value="The `beginning time` of the `time window`.\nIf `this value` differs from `the latest value`, then:\n1. This value will be updated with `the latest value`.\n2. The current score will be copied to the previous score.\n")
    @Nullable
    private Long beginningOfCurrentTimeWindow;
    @Nullable
    private Integer previousScore;
    @Nullable
    private Integer currentScore;
    private transient LeaderBoardCache ownerCache;

    public static LeaderBoardSnapshot of(@NotNull LeaderBoardTimeWindow timeWindowType) {
        LeaderBoardSnapshot leaderBoardSnapshot = new LeaderBoardSnapshot();
        leaderBoardSnapshot.timeWindow = timeWindowType;
        return leaderBoardSnapshot;
    }

    public static List<LeaderBoardSnapshot> makeDefaultList() {
        ArrayList<LeaderBoardSnapshot> list = new ArrayList<LeaderBoardSnapshot>();
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.HOURLY));
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.DAILY));
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.WEEKLY));
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.MONTHLY));
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.YEARLY));
        list.add(LeaderBoardSnapshot.of(LeaderBoardTimeWindow.ALL_TIME));
        return list;
    }

    public boolean hasEffectiveScore() {
        return this.getPreviousScore() != null && this.getCurrentScore() != null;
    }

    public int getEffectiveScore() {
        return Math.abs(this.currentScore - this.previousScore);
    }

    @Generated
    public LeaderBoardTimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    @Nullable
    @Generated
    public Long getBeginningOfCurrentTimeWindow() {
        return this.beginningOfCurrentTimeWindow;
    }

    @Nullable
    @Generated
    public Integer getPreviousScore() {
        return this.previousScore;
    }

    @Nullable
    @Generated
    public Integer getCurrentScore() {
        return this.currentScore;
    }

    @Generated
    public LeaderBoardCache getOwnerCache() {
        return this.ownerCache;
    }

    @Generated
    public LeaderBoardSnapshot setTimeWindow(LeaderBoardTimeWindow timeWindow) {
        this.timeWindow = timeWindow;
        return this;
    }

    @Generated
    public LeaderBoardSnapshot setBeginningOfCurrentTimeWindow(@Nullable Long beginningOfCurrentTimeWindow) {
        this.beginningOfCurrentTimeWindow = beginningOfCurrentTimeWindow;
        return this;
    }

    @Generated
    public LeaderBoardSnapshot setPreviousScore(@Nullable Integer previousScore) {
        this.previousScore = previousScore;
        return this;
    }

    @Generated
    public LeaderBoardSnapshot setCurrentScore(@Nullable Integer currentScore) {
        this.currentScore = currentScore;
        return this;
    }

    @Generated
    public LeaderBoardSnapshot setOwnerCache(LeaderBoardCache ownerCache) {
        this.ownerCache = ownerCache;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaderBoardSnapshot)) {
            return false;
        }
        LeaderBoardSnapshot other = (LeaderBoardSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$beginningOfCurrentTimeWindow = this.getBeginningOfCurrentTimeWindow();
        Long other$beginningOfCurrentTimeWindow = other.getBeginningOfCurrentTimeWindow();
        if (this$beginningOfCurrentTimeWindow == null ? other$beginningOfCurrentTimeWindow != null : !((Object)this$beginningOfCurrentTimeWindow).equals(other$beginningOfCurrentTimeWindow)) {
            return false;
        }
        Integer this$previousScore = this.getPreviousScore();
        Integer other$previousScore = other.getPreviousScore();
        if (this$previousScore == null ? other$previousScore != null : !((Object)this$previousScore).equals(other$previousScore)) {
            return false;
        }
        Integer this$currentScore = this.getCurrentScore();
        Integer other$currentScore = other.getCurrentScore();
        if (this$currentScore == null ? other$currentScore != null : !((Object)this$currentScore).equals(other$currentScore)) {
            return false;
        }
        LeaderBoardTimeWindow this$timeWindow = this.getTimeWindow();
        LeaderBoardTimeWindow other$timeWindow = other.getTimeWindow();
        return !(this$timeWindow == null ? other$timeWindow != null : !((Object)((Object)this$timeWindow)).equals((Object)other$timeWindow));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LeaderBoardSnapshot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $beginningOfCurrentTimeWindow = this.getBeginningOfCurrentTimeWindow();
        result = result * 59 + ($beginningOfCurrentTimeWindow == null ? 43 : ((Object)$beginningOfCurrentTimeWindow).hashCode());
        Integer $previousScore = this.getPreviousScore();
        result = result * 59 + ($previousScore == null ? 43 : ((Object)$previousScore).hashCode());
        Integer $currentScore = this.getCurrentScore();
        result = result * 59 + ($currentScore == null ? 43 : ((Object)$currentScore).hashCode());
        LeaderBoardTimeWindow $timeWindow = this.getTimeWindow();
        result = result * 59 + ($timeWindow == null ? 43 : ((Object)((Object)$timeWindow)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LeaderBoardSnapshot(timeWindow=" + String.valueOf((Object)this.getTimeWindow()) + ", beginningOfCurrentTimeWindow=" + this.getBeginningOfCurrentTimeWindow() + ", previousScore=" + this.getPreviousScore() + ", currentScore=" + this.getCurrentScore() + ")";
    }

    @Generated
    public LeaderBoardSnapshot(LeaderBoardTimeWindow timeWindow, @Nullable Long beginningOfCurrentTimeWindow, @Nullable Integer previousScore, @Nullable Integer currentScore, LeaderBoardCache ownerCache) {
        this.timeWindow = timeWindow;
        this.beginningOfCurrentTimeWindow = beginningOfCurrentTimeWindow;
        this.previousScore = previousScore;
        this.currentScore = currentScore;
        this.ownerCache = ownerCache;
    }

    @Generated
    public LeaderBoardSnapshot() {
    }
}

