/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.skin.service;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.Pair;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.config.mapper.wrapper.PropertyWrapper;
import mod.fuji.module.initializer.skin.SkinInitializer;
import mod.fuji.module.initializer.skin.structure.SkinDataNode;
import mod.fuji.module.initializer.skin.structure.SkinDescriptor;
import mod.fuji.module.initializer.skin.structure.SkinStorage;
import mod.fuji.module.initializer.skin.structure.SkinSyncer;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinService {
    @NotNull
    public static Property getEffectiveSkin(GameProfile gameProfile) {
        return SkinStorage.withSkinData(gameProfile, SkinDataNode::getSkinProperty).toVanillaType();
    }

    public static int changeSkin(@NotNull class_3222 player, @NotNull Supplier<Property> skinSupplier) {
        SkinService.changeSkinAsync(player.method_7334(), skinSupplier).thenAccept(success -> {
            if (!success.booleanValue()) {
                TextHelper.sendTextByKey(player, "skin.change_skin.failed", new Object[0]);
                return;
            }
            TextHelper.sendTextByKey(player, "skin.change_skin.success", new Object[0]);
        });
        return 1;
    }

    @NotNull
    public static List<SkinDescriptor> getDefaultSkinList() {
        return SkinInitializer.config.model().getDefaultSkin().getDefaultSkinList();
    }

    public static Optional<SkinDescriptor> findSkinDescriptor(String skinName) {
        return SkinService.getDefaultSkinList().stream().filter(it -> it.getSkinName().equals(skinName)).findFirst();
    }

    @NotNull
    public static Property getPreferredDefaultSkin() {
        String preferredDefaultSkinNameForNewPlayers = SkinInitializer.config.model().getDefaultSkin().getPreferredSkinName();
        Optional<SkinDescriptor> preferredDefaultSkin = SkinService.getDefaultSkinList().stream().filter(it -> it.getSkinName().contains(preferredDefaultSkinNameForNewPlayers)).findFirst();
        return preferredDefaultSkin.map(skinDescriptor -> skinDescriptor.getSkinProperty().toVanillaType()).orElseGet(SkinService::getRandomDefaultSkin);
    }

    public static Property getRandomDefaultSkin() {
        return RandomUtil.drawList(SkinService.getDefaultSkinList()).getSkinProperty().toVanillaType();
    }

    private static boolean isSkinPropertyEqual(@NotNull Property x, @NotNull GameProfile y) {
        try {
            JsonObject xJsonObject = SkinService.makeComparableJsonObjectFromSkinProperty(x);
            Optional py = AuthlibHelper.getProperties(y).get((Object)"textures").stream().findFirst();
            if (py.isEmpty()) {
                return false;
            }
            JsonObject yJsonObject = SkinService.makeComparableJsonObjectFromSkinProperty((Property)py.get());
            return xJsonObject.equals((Object)yJsonObject);
        }
        catch (Exception e) {
            LogUtil.error("Failed to compare the skin textures: x = {}, y = {}", x, y, e);
            return false;
        }
    }

    @NotNull
    private static JsonObject makeComparableJsonObjectFromSkinProperty(Property property) {
        String jsonString = new String(Base64.getDecoder().decode(AuthlibHelper.getPropertyValue(property)), StandardCharsets.UTF_8);
        JsonObject jsonObject = GsonMapper.fromJson(jsonString, JsonObject.class);
        jsonObject.remove("timestamp");
        return jsonObject;
    }

    @NotNull
    private static CompletableFuture<Boolean> changeSkinAsync(@NotNull GameProfile target, @NotNull Supplier<Property> skinSupplier) {
        MinecraftServer server = ServerHelper.getServer();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            @Nullable Property skinProperty = (Property)skinSupplier.get();
            LogUtil.debug("Resolved skin property from skin supplier: target = {}, skin = {}", AuthlibHelper.getName(target), skinProperty);
            if (skinProperty == null) {
                throw new IllegalStateException("Failed to resolve skin property from skin supplier.");
            }
            SkinStorage.withSkinData(target, node -> {
                node.setSkinProperty(PropertyWrapper.fromVanillaType(skinProperty));
                return null;
            });
            return Pair.of((Object)target, (Object)skinProperty);
        }).thenApplyAsync(pair -> {
            @Nullable Property skinProperty = (Property)pair.right();
            if (skinProperty == null) {
                return Boolean.FALSE;
            }
            GameProfile gameProfile = (GameProfile)pair.left();
            @Nullable class_3222 player = PlayerHelper.Lookup.getOnlinePlayerByUuid(AuthlibHelper.getId(gameProfile)).orElse(null);
            if (player == null) {
                return Boolean.FALSE;
            }
            if (SkinService.isSkinPropertyEqual(skinProperty, player.method_7334())) {
                return Boolean.TRUE;
            }
            AuthlibHelper.modifyGameProfile(player.method_7334(), skinProperty);
            SkinSyncer.broadcastGameProfileChange(player);
            return Boolean.TRUE;
        }, (Executor)server)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(e -> Boolean.FALSE);
    }
}

