/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.tpa.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.tpa.service.TpaService;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpaGui
extends PagedGui<class_3222> {
    public TpaGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<class_3222> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "tpa.gui.title", new Object[0]), entities, pageIndex);
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "tpa.gui.help.lore")));
    }

    @Override
    @NotNull
    protected PagedGui<class_3222> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<class_3222> entities, int pageIndex) {
        return new TpaGui(parent, player, entities, pageIndex);
    }

    @NotNull
    public static TpaGui make(@NotNull class_3222 player) {
        List<class_3222> entities = PlayerHelper.Lookup.getOnlinePlayers().stream().filter(it -> !it.equals((Object)player)).toList();
        return new TpaGui(null, player, entities, 0);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull class_3222 entity) {
        GuiElementBuilder builder = (GuiElementBuilder)GuiHelper.Button.makeLuckyBlockButton().setName(TextHelper.getTextByKey(this.player, "player.name", PlayerHelper.getPlayerName((class_1657)entity))).setCallback(clickType -> this.onEntityClicked((ClickType)clickType, entity));
        return builder.build();
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        GuiHelper.PlayerSkull.fillPlayerHeadTextures((SlotGuiInterface)this);
    }

    private void onEntityClicked(@NotNull ClickType clickType, @NotNull class_3222 entity) {
        if (clickType.isLeft) {
            TpaService.doRequest(this.player, entity, false);
            this.close();
            return;
        }
        if (clickType.isRight) {
            TpaService.doRequest(this.player, entity, true);
            this.close();
            return;
        }
    }
}

