/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world_downloader;

import com.google.common.collect.EvictingQueue;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.ExceptionUtil;
import mod.fuji.core.auxiliary.IOUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.world_downloader.config.model.WorldDownloaderConfigModel;
import mod.fuji.module.initializer.world_downloader.structure.FileDownloadHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826613773L, value="Allows a player to download nearest `region` file.\n\nIt's useful for players to save and debug a `redstone structure`.\nIt simply downloads the `identical` region file used by the server.\nSimple, no surprises.\nIt's also useful for players to download other's buildings, or their own buildings.\n")
public class WorldDownloaderInitializer
extends ModuleInitializer {
    private static final double BYTE_TO_MEGABYTE = 1048576.0;
    private static final BaseConfigurationHandler<WorldDownloaderConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", WorldDownloaderConfigModel.class);
    private static EvictingQueue<String> downloadContextQueue;
    private static HttpServer httpServer;

    private static void restartHttpServer() {
        if (httpServer != null) {
            httpServer.stop(0);
        }
        try {
            httpServer = HttpServer.create(new InetSocketAddress(WorldDownloaderInitializer.config.model().port), 0);
            httpServer.start();
        }
        catch (IOException e) {
            LogUtil.error("Failed to start http server.", e);
        }
    }

    public static void safelyRemoveContext(String path) {
        try {
            httpServer.removeContext(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Document(id=1751826617256L, value="Download the region file around you.")
    @CommandNode(value="download")
    private static int $download(@CommandSource class_3222 player) {
        if (httpServer == null) {
            WorldDownloaderInitializer.restartHttpServer();
        }
        if (downloadContextQueue.remainingCapacity() == 0) {
            LogUtil.debug("Contexts is full, remove the oldest context. {}", downloadContextQueue.peek());
            WorldDownloaderInitializer.safelyRemoveContext((String)downloadContextQueue.poll());
        }
        String url = WorldDownloaderInitializer.config.model().url_format;
        int port = WorldDownloaderInitializer.config.model().port;
        url = url.replace("%port%", String.valueOf(port));
        String path = "/world-download/" + RandomUtil.randomUUID();
        url = url.replace("%path%", path);
        downloadContextQueue.add((Object)path);
        File file = WorldDownloaderInitializer.compressRegionFile(player);
        TextHelper.sendBroadcastByKey("world_downloader.request", PlayerHelper.getPlayerName((class_1657)player), (double)file.length() / 1048576.0);
        httpServer.createContext(path, new FileDownloadHandler(file, WorldDownloaderInitializer.config.model().bytes_per_second_limit));
        TextHelper.sendTextByKey(player, "world_downloader.response", url);
        return 1;
    }

    @NotNull
    public static File compressRegionFile(@NotNull class_3222 player) {
        File output;
        class_1923 chunkPos = player.method_31476();
        int regionX = chunkPos.method_17885();
        int regionZ = chunkPos.method_17886();
        class_3218 world = EntityHelper.getServerWorld((class_1297)player);
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        class_32.class_5143 session = server.field_23784;
        final File worldDirectory = session.method_27424(dimensionKey).toFile();
        final String regionName = "r." + regionX + "." + regionZ + ".mca";
        ArrayList<File> input = new ArrayList<File>(){
            {
                this.add(new File(worldDirectory, "region" + File.separator + regionName));
                this.add(new File(worldDirectory, "poi" + File.separator + regionName));
                this.add(new File(worldDirectory, "entities" + File.separator + regionName));
            }
        };
        try {
            output = Files.createTempFile(regionName + "#", ".zip", new FileAttribute[0]).toFile();
            IOUtil.Compressor.compressFiles(worldDirectory, (List<File>)input, output);
        }
        catch (IOException e) {
            throw ExceptionUtil.makeReThrownException(e);
        }
        LogUtil.info("Generate region file: {}", output.getAbsolutePath());
        return output;
    }

    @EventConsumer
    private static void onServerStarted(@Unused ServerStartedEvent event) {
        downloadContextQueue = EvictingQueue.create((int)WorldDownloaderInitializer.config.model().max_simultaneous_download_count);
    }

    @Override
    protected void onReload() {
        WorldDownloaderInitializer.restartHttpServer();
    }
}

