/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.random_teleport.searcher;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.service.async_chunk_loader.AsyncChunkLoader;
import mod.fuji.core.service.random_teleport.filter.PositionFilter;
import mod.fuji.core.service.random_teleport.generator.ChunkCandidateBlocksGenerator;
import mod.fuji.core.service.random_teleport.generator.PositionXZGenerator;
import mod.fuji.core.service.random_teleport.searcher.PositionYSearcher;
import mod.fuji.core.service.random_teleport.structure.PositionSearchContext;
import mod.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class PositionSearcher {
    public static void search(@NotNull PositionSearchContext context) {
        RandomTeleportSettings settings = context.getSettings();
        class_2338 blockPosInChunk = PositionXZGenerator.getRandomXZ(settings);
        TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.checking_chunk", blockPosInChunk.method_10263(), blockPosInChunk.method_10260(), context.getAttempts(), context.getMaxAttempts());
        class_3218 serverWorld = WorldHelper.getWorldOrThrow(settings.getDimension());
        if (settings.getBiomes().getOnlyAcceptBiomesMode().isEnable()) {
            Pair pair = serverWorld.method_42108(it -> it.method_40230().map(biome -> {
                String idAsString = RegistryHelper.getIdAsString(biome);
                return settings.getBiomes().getOnlyAcceptBiomesMode().getAccept().stream().anyMatch(acceptBiome -> acceptBiome.equals(idAsString));
            }).orElse(false), blockPosInChunk = blockPosInChunk.method_33096(context.getPlayer().method_31478()), 6400, 32, 64);
            if (pair == null) {
                TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.biome_locate_failed", new Object[0]);
            } else {
                blockPosInChunk = (class_2338)pair.getFirst();
            }
        }
        if (!PositionFilter.isInsideWorldBorder(serverWorld, blockPosInChunk)) {
            TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_out_of_border", new Object[0]);
            return;
        }
        class_1923 chunkPos = WorldHelper.makeChunkPos(blockPosInChunk);
        int asyncChunkLoadingTimeoutTicks = Math.min(1200, context.getSettings().getAsyncChunkLoadingTimeoutTicks());
        CompletableFuture<Void> voidCompletableFuture = AsyncChunkLoader.loadChunkAsync(serverWorld, chunkPos, asyncChunkLoadingTimeoutTicks, PositionSearcher.getChunkConsumer(context, serverWorld), PositionSearcher.getOnFailedHook(context));
        voidCompletableFuture.join();
    }

    @NotNull
    private static Runnable getOnFailedHook(@NotNull PositionSearchContext context) {
        return () -> TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.async_chunk_loading_timeout", new Object[0]);
    }

    @NotNull
    private static Consumer<class_2791> getChunkConsumer(@NotNull PositionSearchContext context, @NotNull class_3218 serverWorld) {
        return chunk -> {
            if (chunk.method_12033() >= (long)context.getSettings().getChunkInhabitedTimeLowerThanTicks()) {
                TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_inhabited_chunk", new Object[0]);
                return;
            }
            for (class_2338.class_2339 candidateBlockPos : ChunkCandidateBlocksGenerator.getChunkCandidateBlocks(chunk.method_12004())) {
                int blockPosX = candidateBlockPos.method_10263();
                int blockPosZ = candidateBlockPos.method_10260();
                PositionYSearcher positionYSearcher = PositionYSearcher.forWorld(serverWorld);
                Optional<Integer> blockPosY = positionYSearcher.search((class_2791)chunk, blockPosX, blockPosZ);
                if (blockPosY.isEmpty()) {
                    TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_no_standing_space", new Object[0]);
                    continue;
                }
                int $blockPosY = blockPosY.get();
                class_2338 value = new class_2338(blockPosX, $blockPosY, blockPosZ);
                String biomeId = WorldHelper.getBiomeId(serverWorld, value);
                RandomTeleportSettings settings = context.getSettings();
                if (settings.getBiomes().getSkip().contains(biomeId)) {
                    TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_biome", biomeId);
                    continue;
                }
                class_2338 blockPos = new class_2338(blockPosX, $blockPosY - 1, blockPosZ);
                class_2680 blockState = chunk.method_8320(blockPos);
                if (!PositionFilter.isSafeBlock(settings, blockState)) {
                    TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_block", RegistryHelper.getIdAsString(blockState));
                    continue;
                }
                if (!PositionFilter.isYInRange(settings, blockPos)) {
                    TextHelper.sendTextByKey(context.getPlayer(), "rtp.progress.skip_out_of_range_y", blockPos.method_10264());
                    continue;
                }
                context.setResult(Optional.of(value));
            }
        };
    }
}

