/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.nametag.structure;

import java.util.Optional;
import lombok.Generated;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PacketHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.module.initializer.nametag.NametagInitializer;
import mod.fuji.module.initializer.nametag.config.model.NametagConfigModel;
import mod.fuji.module.initializer.nametag.service.NametagService;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2716;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class NametagEntity
extends class_8113.class_8123 {
    private final class_3222 ownerPlayer;
    private boolean shouldRenderPreviousValue = false;

    private NametagEntity(@NotNull class_1299<?> entityType, @NotNull class_1937 world, @NotNull class_3222 ownerPlayer) {
        super(entityType, world);
        this.ownerPlayer = ownerPlayer;
    }

    @NotNull
    public static NametagEntity make(@NotNull class_3222 player) {
        LogUtil.debug("Make nametag for player: {}", PlayerHelper.getPlayerName((class_1657)player));
        NametagEntity nametagEntity = new NametagEntity(class_1299.field_42457, (class_1937)EntityHelper.getServerWorld((class_1297)player), player);
        nametagEntity.method_5684(true);
        return nametagEntity;
    }

    public boolean shouldRemove() {
        if (this.ownerPlayer.method_31481()) {
            return true;
        }
        return this.method_31481();
    }

    public void setRemoved() {
        this.method_5650(class_1297.class_5529.field_26999);
        PacketHelper.sendPacketToAll(new class_2716(new int[]{this.method_5628()}));
    }

    private void setDisplayFlag(byte flag, boolean value) {
        class_2945 dataTracker = this.method_5841();
        byte oldValue = (Byte)dataTracker.method_12789(class_8113.class_8123.field_42439);
        byte newValue = EntityHelper.withFlagValue(oldValue, flag, value);
        dataTracker.method_12778(class_8113.class_8123.field_42439, (Object)newValue);
    }

    public void updateTrackedData() {
        NametagConfigModel config = NametagInitializer.config.model();
        this.method_48847(class_8113.class_8114.field_42409);
        class_2561 text = TextHelper.getTextByValue(this.ownerPlayer, config.style.text, new Object[0]);
        this.method_48911(text);
        this.method_5841().method_12778(field_42401, (Object)new Vector3f(config.style.offset.x, config.style.offset.y, config.style.offset.z));
        this.method_48873(config.style.size.width);
        this.method_48875(config.style.size.height);
        this.method_48910(config.style.color.background);
        this.method_48909(config.style.color.text_opacity);
        if (config.style.brightness.override_brightness) {
            this.method_48846(new class_8104(config.style.brightness.block, config.style.brightness.sky));
        }
        if (NametagService.shouldRenderNametagEntity(this)) {
            this.method_5841().method_12778(field_42402, (Object)new Vector3f(config.style.scale.x, config.style.scale.y, config.style.scale.z));
        } else {
            this.method_5841().method_12778(field_42402, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        }
        this.setDisplayFlag((byte)1, config.style.shadow.shadow);
        this.method_48862(config.style.shadow.shadow_radius);
        this.method_48872(config.style.shadow.shadow_strength);
        this.setDisplayFlag((byte)2, config.render.see_through_blocks);
        this.method_48861(config.render.view_range);
        Optional.ofNullable(this.method_5841().method_12781()).ifPresent(dirtyEntries -> {
            class_2739 entityTrackerUpdateS2CPacket = new class_2739(this.method_5628(), dirtyEntries);
            PacketHelper.sendPacketToAll(entityTrackerUpdateS2CPacket);
        });
    }

    public void method_5773() {
        NametagService.getNametagEntityRemovalReason(this.ownerPlayer).ifPresent(reason -> {
            LogUtil.debug("Discard nametag entity {}: {}", new Object[]{this, reason});
            this.setRemoved();
        });
        boolean shouldRenderCurrentValue = NametagService.shouldRenderNametagEntity(this);
        if (shouldRenderCurrentValue != this.shouldRenderPreviousValue) {
            this.shouldRenderPreviousValue = shouldRenderCurrentValue;
            this.updateTrackedData();
        }
    }

    @Generated
    public class_3222 getOwnerPlayer() {
        return this.ownerPlayer;
    }
}

