/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.tab.job;

import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.job.JobManager;
import mod.fuji.core.job.abst.CronJob;
import mod.fuji.module.initializer.tab.TabListInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;

@Document(id=1751826908172L, value="This `job` is used to `update` the `header` and `footer` in `tab` list.\n")
public class RenderHeaderAndFooterJob
extends CronJob {
    public RenderHeaderAndFooterJob() {
        super(() -> TabListInitializer.config.model().getUpdateCron());
    }

    private static void updateTabList() {
        String headerFormat = RandomUtil.drawList(TabListInitializer.config.model().getStyle().getHeader());
        String footerFormat = RandomUtil.drawList(TabListInitializer.config.model().getStyle().getFooter());
        for (class_3222 player : PlayerHelper.Lookup.getOnlinePlayers()) {
            @NotNull Object header = TabListInitializer.config.model().getStyle().isEnableHeader() ? TextHelper.getTextByValue(player, headerFormat, new Object[0]) : class_2561.method_43473();
            @NotNull Object footer = TabListInitializer.config.model().getStyle().isEnableFooter() ? TextHelper.getTextByValue(player, footerFormat, new Object[0]) : class_2561.method_43473();
            player.field_13987.method_14364((class_2596)new class_2772((class_2561)header, (class_2561)footer));
        }
    }

    @EventConsumer
    private static void scheduleTabListRenderJob(@Unused ServerStartedEvent event) {
        RenderHeaderAndFooterJob renderHeaderAndFooterJob = new RenderHeaderAndFooterJob();
        JobManager.addJob(renderHeaderAndFooterJob);
    }

    public void execute(JobExecutionContext context) {
        RenderHeaderAndFooterJob.updateTabList();
    }
}

