/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager.structure;

import com.mojang.serialization.Lifecycle;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.FabricApiHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.extension.SimpleRegistryExtension;
import net.minecraft.class_2370;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class RuntimeDimensionLoader {
    private static Lifecycle makeDefaultRegistryEntryInfo() {
        return Lifecycle.stable();
    }

    public static void loadRuntimeDimension(class_3218 dimension, class_5363 dimensionOptions) {
        class_2370 dimensionOptionsRegistry = (class_2370)RegistryHelper.getRegistry(class_7924.field_41224);
        boolean original = ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$isFrozen();
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(false);
        class_5321 worldRegistryKey = dimension.method_27983();
        class_5321 dimensionOptionsRegistryKey = class_7924.method_47518((class_5321)worldRegistryKey);
        if (!dimensionOptionsRegistry.method_35842(dimensionOptionsRegistryKey)) {
            LogUtil.debug("Add entry into Registry<DimensionOptions>: key = {}, value = {}", dimensionOptionsRegistryKey, dimensionOptions);
            dimensionOptionsRegistry.method_10272(dimensionOptionsRegistryKey, (Object)dimensionOptions, RuntimeDimensionLoader.makeDefaultRegistryEntryInfo());
        }
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(original);
        MinecraftServer server = ServerHelper.getServer();
        server.field_4589.put(dimension.method_27983(), dimension);
        try {
            FabricApiHelper.fireOnWorldLoadEvent(server, dimension);
        }
        catch (Exception e) {
            LogUtil.error("Failed to fire onWorldLoad event in fabric-api mod.", e);
        }
    }

    public static void unloadDimension(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        if (server.field_4589.remove(dimensionKey, world)) {
            try {
                FabricApiHelper.fireOnWorldUnloadEvent(server, world);
            }
            catch (Exception e) {
                LogUtil.error("Failed to fire onWorldUnload event in fabric-api mod.", e);
            }
            class_2370 dimensionsRegistry = (class_2370)RegistryHelper.getRegistry(class_7924.field_41224);
            SimpleRegistryExtension.remove(dimensionsRegistry, dimensionKey.method_29177());
        }
    }
}

