/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.cleaner;

import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.cleaner.config.model.CleanerConfigModel;
import mod.fuji.module.initializer.cleaner.config.transformer.CleanerV1SchemaTransformer;
import mod.fuji.module.initializer.cleaner.service.CleanerService;
import net.minecraft.class_2168;

@Document(id=1751826898176L, value="This module provides an `entity cleaner`.\nIt monitors specified conditions and `clean` entities that `match defined rules`.\n")
@ColorBoxes(value={@ColorBox(id=1751870582940L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The vanilla Minecraft `Item Entity` de-spawning.\nIn `vanilla Minecraft`, all `item entities` automatically de-spawn after `6000 ticks (5 minutes)`.\nIn most case, the vanilla `item de-spawning mechanism` is sufficient to meet your needs.\n\nIt's strongly recommended to use the `cleaner` module only for handling `special case`.\nFor example, if your players have built a `large mob farm`, which produces excessive amount of `ender pearls`.\nYou may define a `clean matcher` to match the `ender pearl` entity.\n\n\u25c9 Cleaning scope of the `cleaner` module.\nThis module exclusively targets `entities`.\nIt can not be used to clean `blocks` or `block entities`\n<blue>NOTE: The `block entity` is not a true `entity` within Minecraft internal.\n"), @ColorBox(id=1756789894197L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Supported `cleanup methods`\n- `KILL`: Remove the entity as if it had `died`, triggering the `entity death event`. (Loot will be dropped.)\n- `DISCARD`: Remove the entity by `discarding` it, without triggering any events. (No loot will be dropped.)\n\nNOTE: For `item entity`, there is no significant difference between the available cleanup methods.\n"), @ColorBox(id=1756790951617L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 What is a `translatable key`?\nA `translatable key` is an identifier used internally by Minecraft to reference `items`, `block-based items`, and other `entities`.\nIt corresponds to the keys defined in Minecraft's `translation files`.\nAn example translation file can be found here:\nhttps://github.com/fuji-fabric/fuji/blob/dev/.github/files/en_us.json\n\nCommon key formats include:\n- `item.minecraft.*`\n- `block.minecraft.*`\n- `entity.minecraft.*`\n"), @ColorBox(id=1756789316771L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Define a `matcher` to clean `item entities`.\nA `matcher` identifies entities using their `translatable key`.\n- For `minecraft:gold_ingot` item-entity, the key is `item.minecraft.gold_ingot`\n- For `minecraft:gold_block` item-entity, the key is `block.minecraft.gold_block`\n\nAlthough the key for a block-based item begins with `block.`, it still refers to an `item entity` whose stack contains `minecraft:gold_block`.\n\n\u25c9 Define a `matcher` to clean `living entity`.\nTo enable cleaning of living entities:\n1. Set `ignore_living_entity` to `false`.\n2. Define a `matcher` for the target entity, for example: `entity.minecraft.skeleton`.\n")})
@CommandNode(value="cleaner")
@CommandRequirement(level=4)
public class CleanerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CleanerConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CleanerConfigModel.class).installTransformer(new CleanerV1SchemaTransformer());

    @Document(id=1756788946930L, value="Perform entity cleanup, and generate a cleanup report if any entities are removed.")
    @CommandNode(value="clean")
    private static int $clean(@CommandSource class_2168 source) {
        CleanerService.cleanEntities();
        return 1;
    }
}

