/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_state.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.core.service.cache.structure.Cache;
import mod.fuji.module.initializer.command_state.service.CommandStateService;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPlayerStatesGui
extends PagedGui<GuiElementInterface> {
    private final class_3222 target;

    public ListPlayerStatesGui(@Nullable SimpleGui parent, @NotNull class_3222 source, @NotNull class_3222 target, @NotNull List<GuiElementInterface> entities, int pageIndex) {
        super(parent, source, TextHelper.getTextByKey(source, "command_state.info.gui.title", PlayerHelper.getPlayerName((class_1657)target)), entities, pageIndex);
        this.target = target;
    }

    @Override
    protected PagedGui<GuiElementInterface> makePage(@Nullable SimpleGui parent, @NotNull class_3222 source, class_2561 title, @NotNull List<GuiElementInterface> entities, int pageIndex) {
        return new ListPlayerStatesGui(parent, source, this.target, entities, pageIndex);
    }

    @NotNull
    public static ListPlayerStatesGui make(@NotNull class_3222 source, @NotNull class_3222 target) {
        ArrayList<GuiElementInterface> entities = new ArrayList<GuiElementInterface>();
        CommandStateService.withPlayerStateMap(target, playerStates -> {
            ConcurrentHashMap<String, Cache<Boolean>> stateMap = playerStates.getStateMap();
            stateMap.forEach((stateId, stateCache) -> {
                GuiElementBuilder builder = new GuiElementBuilder();
                builder.setName((class_2561)class_2561.method_43470((String)stateId));
                boolean isInState = (Boolean)stateCache.getValue();
                builder.setItem(isInState ? class_1802.field_8295 : class_1802.field_8586);
                builder.setLore(List.of(TextHelper.getTextByKey(source, "entity.value", isInState), TextHelper.getTextByKey(source, "entity.updated_timestamp", ChronosUtil.Formatter.formatDate(stateCache.getUpdatedTimestamp()))));
                entities.add((GuiElementInterface)builder.build());
            });
        });
        return new ListPlayerStatesGui(null, source, target, entities, 0);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull GuiElementInterface entity) {
        return entity;
    }
}

