/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.builder.component;

import java.util.List;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.module.initializer.document.builder.component.DocumentBuilder;
import mod.fuji.module.initializer.document.builder.context.DocumentBuilderContext;
import mod.fuji.module.initializer.document.formatter.MarkdownDocumentFormatter;
import org.jetbrains.annotations.NotNull;

public class ModuleColorBoxesDocumentBuilder
extends DocumentBuilder {
    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<ColorBox> colorBoxes = DocumentUtil.getColorBoxes(documentBuilderContext.getModulePathString());
        if (!colorBoxes.isEmpty()) {
            StringBuilder documentBuilder = documentBuilderContext.getDocumentBuilder();
            documentBuilder.append("## Color Boxes").append(System.lineSeparator()).append(System.lineSeparator());
            colorBoxes.forEach(it -> this.buildColorBox(documentBuilderContext, (ColorBox)it));
        }
    }

    private void buildColorBox(@NotNull DocumentBuilderContext documentBuilderContext, @NotNull ColorBox colorBox) {
        String colorBoxDocumentString = MarkdownDocumentFormatter.parseDocumentString(colorBox.value());
        documentBuilderContext.getDocumentBuilder().append(":::%s".formatted(this.toAdmonitionName(colorBox))).append(System.lineSeparator()).append(System.lineSeparator()).append(colorBoxDocumentString).append(System.lineSeparator()).append(":::").append(System.lineSeparator()).append(System.lineSeparator());
    }

    @NotNull
    private String toAdmonitionName(@NotNull ColorBox colorBox) {
        if (colorBox.color() == ColorBox.ColorBoxTypes.DANGER) {
            return "colorbox-danger";
        }
        if (colorBox.color() == ColorBox.ColorBoxTypes.WARNING) {
            return "colorbox-warning";
        }
        if (colorBox.color() == ColorBox.ColorBoxTypes.NOTE) {
            return "colorbox-note";
        }
        if (colorBox.color() == ColorBox.ColorBoxTypes.TIP) {
            return "colorbox-tip";
        }
        if (colorBox.color() == ColorBox.ColorBoxTypes.EXAMPLE) {
            return "colorbox-example";
        }
        throw new IllegalArgumentException("Unknown color: " + String.valueOf((Object)colorBox.color()));
    }
}

