/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.home;

import com.google.common.collect.BiMap;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.MetaDescriptor;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.home.command.argument.wrapper.HomeName;
import mod.fuji.module.initializer.home.config.model.HomeDataModel;
import mod.fuji.module.initializer.home.gui.ListHomesGui;
import mod.fuji.module.initializer.home.service.HomeService;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

@Document(id=1751827004970L, value="This module allows players to define their homes.\n")
public class HomeInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000367398L, value="The home amount limit for this player.\n")
    private static final MetaDescriptor<Integer> MAX_HOME_AMOUNT_META = new MetaDescriptor<Integer>("fuji.home.home_limit", Integer::valueOf, 1752000367398L);
    public static final BaseConfigurationHandler<HomeDataModel> data = ObjectConfigurationHandler.ofModule("home.json", HomeDataModel.class).enableAutoSaveFeature();

    @CommandNode(value="home")
    @Document(id=1758555773741L, value="Teleport to any of your homes.")
    private static int $root(@CommandSource class_3222 player) {
        return HomeService.withHomeMap(player).entrySet().stream().findAny().map(it -> {
            ((GlobalPos)it.getValue()).teleport(player);
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(player, "home.no_homes", new Object[0]);
            return 0;
        });
    }

    @CommandNode(value="home tp")
    private static int $tp(@CommandSource class_3222 player, HomeName home) {
        HomeService.ensureHomeNameExisting(player, home);
        BiMap<String, GlobalPos> homes = HomeService.withHomeMap(player);
        String homeName = (String)home.getValue();
        GlobalPos globalPos = (GlobalPos)homes.get((Object)homeName);
        globalPos.teleport(player);
        return 1;
    }

    @CommandNode(value="home unset")
    private static int $unset(@CommandSource class_3222 player, HomeName home) {
        HomeService.ensureHomeNameExisting(player, home);
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String homeName = (String)home.getValue();
        HomeService.removeHome(playerName, homeName);
        TextHelper.sendTextByKey(player, "home.unset.success", homeName);
        return 1;
    }

    @CommandNode(value="home set")
    private static int $set(@CommandSource class_3222 player, HomeName home, Optional<Boolean> override) {
        String homeName;
        BiMap<String, GlobalPos> homes = HomeService.withHomeMap(player);
        if (homes.containsKey((Object)(homeName = (String)home.getValue())) && !override.orElse(false).booleanValue()) {
            TextHelper.sendTextByKey(player, "home.set.fail.need_override", home);
            return 0;
        }
        Optional<Integer> maxHomes = LuckpermsHelper.getMeta(player.method_5667(), MAX_HOME_AMOUNT_META, new Object[0]);
        if (maxHomes.isPresent() && homes.size() >= maxHomes.get()) {
            TextHelper.sendTextByKey(player, "home.set.fail.limit", new Object[0]);
            return 0;
        }
        homes.put((Object)homeName, (Object)GlobalPos.of(player));
        TextHelper.sendTextByKey(player, "home.set.success", home);
        return 1;
    }

    @CommandNode(value="home rename")
    private static int $rename(@CommandSource class_3222 player, HomeName oldName, String newName) {
        HomeService.ensureHomeNameExisting(player, oldName);
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return HomeService.findHome(playerName, newName).map(it -> {
            TextHelper.sendTextByKey(player, "home.rename.fail.exists", newName);
            return 0;
        }).orElseGet(() -> {
            String $oldName = (String)oldName.getValue();
            HomeService.renameHome(playerName, $oldName, newName);
            TextHelper.sendTextByKey(player, "home.rename.success", $oldName, newName);
            return 1;
        });
    }

    @CommandNode(value="home list")
    private static int $list(@CommandSource class_3222 player) {
        TextHelper.sendTextByKey(player, "home.list", HomeService.withHomeMap(player).keySet());
        return 1;
    }

    @CommandNode(value="home gui")
    private static int $gui(@CommandSource class_3222 player) {
        OfflinePlayerName target = new OfflinePlayerName(PlayerHelper.getPlayerName((class_1657)player));
        return HomeInitializer.$gui(player, target);
    }

    @CommandNode(value="home gui")
    @CommandRequirement(level=4)
    private static int $gui(@CommandSource class_3222 player, OfflinePlayerName target) {
        ListHomesGui.make(player, (String)target.getValue()).open();
        return 1;
    }
}

