/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.nametag.structure;

import com.google.errorprone.annotations.Keep;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.PacketHelper;
import mod.fuji.module.initializer.nametag.service.NametagService;
import mod.fuji.module.initializer.nametag.structure.NametagEntity;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2739;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class NametagEntitySyncer {
    public static void syncNametagEntityToClientWorld(@NotNull NametagEntity nametagEntity) {
        NametagEntitySyncer.syncExistingNametagEntities(nametagEntity.getOwnerPlayer());
        NametagEntitySyncer.broadcastNewlyNametagEntityToAllPlayers(nametagEntity);
    }

    @NotNull
    private static class_2752 makeEntityPassengerSetPacket(@NotNull NametagEntity nametagEntity) {
        class_3222 ownerPlayer = nametagEntity.getOwnerPlayer();
        return new class_2752((class_1297)ownerPlayer);
    }

    @Keep
    private static void syncExistingNametagEntities(@NotNull class_3222 audience) {
        NametagService.nametagEntityMap.forEach((key, value) -> {
            class_2604 entitySpawnS2CPacket = NametagEntitySyncer.makeNametagEntitySpawnPacket(value);
            audience.field_13987.method_14364((class_2596)entitySpawnS2CPacket);
            class_2752 entityPassengersSetS2CPacket = NametagEntitySyncer.makeEntityPassengerSetPacket(value);
            audience.field_13987.method_14364((class_2596)entityPassengersSetS2CPacket);
            Optional.ofNullable(value.method_5841().method_46357()).ifPresent(changedEntries -> {
                class_2739 entityTrackerUpdateS2CPacket = new class_2739(value.method_5628(), changedEntries);
                audience.field_13987.method_14364((class_2596)entityTrackerUpdateS2CPacket);
            });
        });
    }

    @NotNull
    private static class_2604 makeNametagEntitySpawnPacket(@NotNull NametagEntity nametagEntity) {
        class_2338 blockPos = nametagEntity.getOwnerPlayer().method_24515().method_10069(0, 3, 0);
        return new class_2604((class_1297)nametagEntity, 0, blockPos);
    }

    private static void broadcastNewlyNametagEntityToAllPlayers(@NotNull NametagEntity nametagEntity) {
        class_2604 entitySpawnS2CPacket = NametagEntitySyncer.makeNametagEntitySpawnPacket(nametagEntity);
        PacketHelper.sendPacketToAll(entitySpawnS2CPacket);
        class_2752 entityPassengersSetS2CPacket = NametagEntitySyncer.makeEntityPassengerSetPacket(nametagEntity);
        PacketHelper.sendPacketToAll(entityPassengersSetS2CPacket);
    }
}

