/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.top_chunks.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.core.service.type_formatter.TypeFormatter;
import mod.fuji.module.initializer.top_chunks.service.TopChunksService;
import mod.fuji.module.initializer.top_chunks.structure.ChunkScore;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopChunksGui
extends PagedGui<ChunkScore> {
    public TopChunksGui(class_3222 player, @NotNull List<ChunkScore> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "top_chunks.list.gui.title", new Object[0]), TopChunksService.trimChunkScoreList(entities), pageIndex);
    }

    @Override
    @NotNull
    protected PagedGui<ChunkScore> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<ChunkScore> entities, int pageIndex) {
        return new TopChunksGui(player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull ChunkScore entity) {
        class_2168 commandSource = this.getPlayer().method_5671();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "top_chunks.prop.dimension", RegistryHelper.getIdAsString((class_1937)entity.getDimension())));
        lore.add(entity.computeChunkLocationText(commandSource));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "top_chunks.prop.players", entity.getPlayers()));
        lore.add(TypeFormatter.formatTypes(commandSource, entity.getType2amount()));
        class_3222 player = this.getPlayer();
        if (ChunkScore.canClickToTeleportToThisChunk(player)) {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.add(TextHelper.getTextByKey(player, "prompt.click.teleport", new Object[0]));
        }
        class_2561 scoreText = TextHelper.getTextByKey(this.getPlayer(), "top_chunks.prop.score", entity.getScore());
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(entity.getPlayers().isEmpty() ? class_1802.field_8483 : class_1802.field_8340).setName(scoreText).setLore(lore).setCallback(() -> {
            if (!ChunkScore.canClickToTeleportToThisChunk(player)) {
                return;
            }
            entity.teleportToThisChunk(player);
            this.close();
        })).build();
    }
}

