/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.Predicate;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.config.parser.JsonPathParser;
import org.jetbrains.annotations.NotNull;

public class JsonUtil {
    public static boolean equalsJsonElementType(@NotNull JsonElement a, @NotNull JsonElement b) {
        if (a.isJsonObject() && b.isJsonObject()) {
            return true;
        }
        if (a.isJsonArray() && b.isJsonArray()) {
            return true;
        }
        if (a.isJsonNull() && b.isJsonNull()) {
            return true;
        }
        if (a.isJsonPrimitive() && b.isJsonPrimitive()) {
            JsonPrimitive pa = a.getAsJsonPrimitive();
            JsonPrimitive pb = b.getAsJsonPrimitive();
            if (pa.isString() && pb.isString()) {
                return true;
            }
            if (pa.isBoolean() && pb.isBoolean()) {
                return true;
            }
            if (pa.isNumber() && pb.isNumber()) {
                return true;
            }
        }
        return false;
    }

    public static boolean existsNode(@NotNull JsonObject root, @NotNull String path) {
        String[] nodes = path.split("\\.", -1);
        if (nodes.length == 0) {
            return false;
        }
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.has(node)) {
                return false;
            }
            if (!root.isJsonObject()) {
                return false;
            }
            root = root.getAsJsonObject(node);
        }
        String theLastKey = nodes[nodes.length - 1];
        return root.has(theLastKey);
    }

    public static boolean isEmpty(JsonObject obj) {
        return obj.size() == 0;
    }

    @NotNull
    public static JsonObject readJsonFile(@NotNull Path path) {
        return ((JsonElement)GsonMapper.fromJson(path, TypeToken.get(JsonElement.class))).getAsJsonObject();
    }

    @NotNull
    public static JsonObject readJsonString(@NotNull String jsonString) {
        return GsonMapper.fromJson(jsonString, JsonElement.class).getAsJsonObject();
    }

    public static <T> Optional<T> readJsonPath(@NotNull JsonObject root, @NotNull String path) {
        try {
            return Optional.ofNullable(JsonPathParser.getJsonPathParser().parse((Object)root).read(path, new Predicate[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T extends JsonElement> void ifJsonElementPresent(@NotNull JsonObject root, @NotNull String key, @NotNull Class<T> expectedJsonElementType, @NotNull Consumer<T> consumer) {
        Optional.ofNullable(root.get(key)).ifPresent(jsonElement -> {
            if (expectedJsonElementType.isInstance(jsonElement)) {
                JsonElement value = (JsonElement)expectedJsonElementType.cast(jsonElement);
                consumer.accept(value);
            }
        });
    }

    public static void writeJsonObject(@NotNull JsonObject jsonObject, @NotNull Path outputFilePath) {
        Files.createDirectories(outputFilePath.getParent(), new FileAttribute[0]);
        String json = GsonMapper.toJsonString((JsonElement)jsonObject);
        Files.writeString(outputFilePath, (CharSequence)json, new OpenOption[0]);
    }
}

