/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.command.argument.adapter.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.argument.wrapper.impl.GreedyCommandString;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.annotation.TestCases;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class GreedyCommandStringArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    private final List<String> greedyStringSeparatorLiterals;

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(GreedyCommandString.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("greedy-command-string");
    }

    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.greedyString();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String string = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        return new GreedyCommandString(string);
    }

    public GreedyCommandStringArgumentTypeAdapter() {
        this.greedyStringSeparatorLiterals = List.of();
    }

    public GreedyCommandStringArgumentTypeAdapter(@NotNull List<String> greedyStringSeparatorLiterals) {
        this.greedyStringSeparatorLiterals = greedyStringSeparatorLiterals;
    }

    @Override
    @TestCases(value={@TestCase(action="Test the greedy command string argument suggestions builder. (Without separator literals)", targets={"Issue: `/run as console send-broadcast <rb>I am %player:name%`", "Issue: `/run as player @s run as console run as fake-op %player:name% say I am %player:name%`", "Issue: `/run as console command-attachment attach-entity-one @e[type=...`", "Issue: `/NOT NOT NOT run as console delay 3 foreach when-online %player:name% send-broadcast You are %player:name%`"}), @TestCase(action="Test the greedy command string argument suggestions builder. (With separator literals)", targets={"Issue: `/chain say 1 chain`", "Issue: `/chain say 1 chain say 2 chain`", "Issue: `/chain say 1 chain        say     2     chain say 3`", "Issue: `/chain say 1 chain chain chain sa`", "Issue: `/chain say 3  chain   send-messa`", "Issue: `/chain say 3  chain   send-message   @s     <rb>Hello`", "Issue: `/chain IF say 1  THEN  say 2  ELSE  say 3  chain  say 4  chain  say 5`"}), @TestCase(action="Test the greedy command string argument suggestions builder. (With placeholders)", targets={"Issue: `/chain run as fake-op @s run as console say 1 chain say 2`", "Issue: `/chain run as fake-op %player:name% sa`", "Issue: `/chain run as fake-op %player:name% run as console run as player @r say 1 chain say 2`", "Issue: `/run as player SakuraWald run as console run as fake-op %player:name% send-message @s I am %player:name%`"})})
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests((context, builder) -> {
            if (((class_2168)context.getSource()).method_44023() == null) {
                return builder.buildFuture();
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            @NotNull String input = builder.getInput();
            @NotNull String inputTrim = input.trim();
            LogUtil.debug("\u25c9 input = '{}'", input);
            LogUtil.debug("\u25c9 builder.getStart() = {}", builder.getStart());
            builder.add(this.makeCommandStringSuggestionsBuilder(player, builder));
            this.makeSeparatorLiteralSuggestionsBuilders(inputTrim, builder).forEach(arg_0 -> ((SuggestionsBuilder)builder).add(arg_0));
            return builder.buildFuture();
        });
    }

    @NotNull
    private SuggestionsBuilder getBoundedBuilder(@NotNull SuggestionsBuilder builder) {
        for (String literal : this.greedyStringSeparatorLiterals) {
            String token;
            String remainingString = builder.getRemaining();
            int index = remainingString.lastIndexOf(token = " " + literal + " ");
            if (index == -1) continue;
            int offset = index + token.length();
            SuggestionsBuilder boundedBuilder = builder.createOffset(builder.getStart() + offset);
            return boundedBuilder;
        }
        return builder;
    }

    private SuggestionsBuilder makeCommandStringSuggestionsBuilder(@NotNull class_3222 player, @NotNull SuggestionsBuilder builder) {
        builder = this.getBoundedBuilder(builder);
        String remainingString = builder.getRemaining();
        LogUtil.debug("remaining string = {}", remainingString);
        LogUtil.debug("remaining string length = {}", remainingString.length());
        class_2168 commandSource = CommandHelper.Source.getCommandSource(player).method_9206(4);
        String commandString = remainingString;
        commandString = commandString.replace("%player:name%", "@r");
        commandString = commandString.stripLeading();
        commandString = CommandHelper.Parser.stripTrailingButKeepOne(commandString);
        LogUtil.debug("command string = {}", commandString);
        int commandStringOffset = commandString.length() - remainingString.length();
        LogUtil.debug("command string offset = {}", commandStringOffset);
        @NotNull Suggestions commandSuggestions = CommandHelper.Suggestion.listSuggestions(commandSource, commandString);
        int offset = commandSuggestions.getRange().getStart() - commandStringOffset;
        int subBuilderStart = builder.getStart() + offset;
        SuggestionsBuilder subBuilder = builder.createOffset(subBuilderStart);
        LogUtil.debug("subBuilder.getStart() = {}", subBuilder.getStart());
        commandSuggestions.getList().forEach(it -> subBuilder.suggest(it.getText()));
        return subBuilder;
    }

    @NotNull
    private List<SuggestionsBuilder> makeSeparatorLiteralSuggestionsBuilders(@NotNull String inputTrim, @NotNull SuggestionsBuilder builder) {
        ArrayList<SuggestionsBuilder> subBuilders = new ArrayList<SuggestionsBuilder>();
        this.greedyStringSeparatorLiterals.forEach(separatorLiteral -> {
            if (inputTrim.endsWith((String)separatorLiteral)) {
                return;
            }
            int subBuilderStart = builder.getInput().length();
            SuggestionsBuilder subBuilder = builder.createOffset(subBuilderStart);
            subBuilder.suggest(" " + separatorLiteral + " ");
            subBuilders.add(subBuilder);
        });
        return subBuilders;
    }
}

